/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;

@InterfaceAudience.Private
public class ExpiredMobFileCleanerChore
extends Chore {
    private static final Log LOG = LogFactory.getLog(ExpiredMobFileCleanerChore.class);
    private final HMaster master;
    private ExpiredMobFileCleaner cleaner;

    public ExpiredMobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-ExpiredMobFileCleanerChore", master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400000), (Stoppable)master);
        this.master = master;
        this.cleaner = new ExpiredMobFileCleaner();
    }

    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, HTableDescriptor> map = htds.getAll();
            for (HTableDescriptor htd : map.values()) {
                for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
                    if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                    this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to clean the expired mob files", (Throwable)e);
        }
    }
}

