/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;

@InterfaceAudience.Private
public class CloneSnapshotHandler
extends CreateTableHandler
implements SnapshotSentinel {
    private static final Log LOG = LogFactory.getLog(CloneSnapshotHandler.class);
    private static final String NAME = "Master CloneSnapshotHandler";
    private final HBaseProtos.SnapshotDescription snapshot;
    private final ForeignExceptionDispatcher monitor;
    private final MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
    private final MonitoredTask status;
    private RestoreSnapshotHelper.RestoreMetaChanges metaChanges;
    private volatile boolean stopped = false;

    public CloneSnapshotHandler(MasterServices masterServices, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) {
        super(masterServices, masterServices.getMasterFileSystem(), hTableDescriptor, masterServices.getConfiguration(), null, masterServices);
        this.snapshot = snapshot;
        this.monitor = new ForeignExceptionDispatcher();
        this.status = TaskMonitor.get().createStatus("Cloning  snapshot '" + snapshot.getName() + "' to table " + hTableDescriptor.getTableName());
    }

    @Override
    public CloneSnapshotHandler prepare() throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        return (CloneSnapshotHandler)super.prepare();
    }

    @Override
    protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, TableName tableName) throws IOException {
        this.status.setStatus("Creating regions for table: " + tableName);
        FileSystem fs = this.fileSystemManager.getFileSystem();
        Path rootDir = this.fileSystemManager.getRootDir();
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, rootDir);
            SnapshotManifest manifest = SnapshotManifest.open(this.conf, fs, snapshotDir, this.snapshot);
            RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(this.conf, fs, manifest, this.hTableDescriptor, tableRootDir, this.monitor, this.status);
            this.metaChanges = restoreHelper.restoreHdfsRegions();
            Preconditions.checkArgument((!this.metaChanges.hasRegionsToRestore() ? 1 : 0) != 0, (Object)"A clone should not have regions to restore");
            Preconditions.checkArgument((!this.metaChanges.hasRegionsToRemove() ? 1 : 0) != 0, (Object)"A clone should not have regions to remove");
            String msg = "Clone snapshot=" + this.snapshot.getName() + " on table=" + tableName + " completed!";
            LOG.info((Object)msg);
            this.status.setStatus(msg + " Waiting for table to be enabled...");
            return this.metaChanges.getRegionsToAdd();
        }
        catch (Exception e) {
            String msg = "clone snapshot=" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " failed because " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            RestoreSnapshotException rse = new RestoreSnapshotException(msg, (Throwable)e, this.snapshot);
            this.monitor.receive(new ForeignException(NAME, (Throwable)rse));
            throw rse;
        }
    }

    @Override
    protected void addRegionsToMeta(CatalogTracker ct, List<HRegionInfo> regionInfos) throws IOException {
        super.addRegionsToMeta(ct, regionInfos);
        this.metaChanges.updateMetaParentRegions(ct, regionInfos);
    }

    @Override
    protected void completed(Throwable exception) {
        this.stopped = true;
        if (exception != null) {
            this.status.abort("Snapshot '" + this.snapshot.getName() + "' clone failed because " + exception.getMessage());
        } else {
            this.status.markComplete("Snapshot '" + this.snapshot.getName() + "' clone completed and table enabled!");
        }
        this.metricsSnapshot.addSnapshotClone(this.status.getCompletionTimestamp() - this.status.getStartTime());
        super.completed(exception);
    }

    @Override
    public boolean isFinished() {
        return this.stopped;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.status.getCompletionTimestamp();
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void cancel(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        String msg = "Stopping clone snapshot=" + this.snapshot + " because: " + why;
        LOG.info((Object)msg);
        this.status.abort(msg);
        this.monitor.receive(new ForeignException(NAME, new CancellationException(why)));
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowExceptionIfFailed() throws ForeignException {
        this.monitor.rethrowException();
    }
}

