/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.MobZookeeper;
import org.apache.hadoop.hbase.mob.mapreduce.MemStoreWrapper;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJobNodeTracker;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SweepReducer
extends Reducer<Text, KeyValue, Writable, Writable> {
    private static final Log LOG = LogFactory.getLog(SweepReducer.class);
    private SequenceFile.Writer writer = null;
    private MemStoreWrapper memstore;
    private Configuration conf;
    private FileSystem fs;
    private Path familyDir;
    private CacheConfig cacheConfig;
    private long compactionBegin;
    private HTable table;
    private HColumnDescriptor family;
    private long mobCompactionDelay;
    private Path mobTableDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.mobCompactionDelay = this.conf.getLong("hbase.mob.compaction.delay", SweepJob.ONE_DAY);
        String tableName = this.conf.get("hbase.mapreduce.inputtable");
        String familyName = this.conf.get("hbase.mapreduce.scan.column.family");
        TableName tn = TableName.valueOf((String)tableName);
        this.familyDir = MobUtils.getMobFamilyPath(this.conf, tn, familyName);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        try {
            this.family = admin.getTableDescriptor(tn).getFamily(Bytes.toBytes((String)familyName));
            if (this.family == null) {
                throw new InvalidFamilyOperationException("Column family '" + familyName + "' does not exist. It might be removed.");
            }
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Fail to close the HBaseAdmin", (Throwable)e);
            }
        }
        Configuration copyOfConf = new Configuration(this.conf);
        copyOfConf.setFloat("hfile.block.cache.size", 1.0E-5f);
        this.cacheConfig = new CacheConfig(copyOfConf);
        this.table = new HTable(this.conf, Bytes.toBytes((String)tableName));
        this.table.setAutoFlush(false, false);
        this.table.setWriteBufferSize(0x100000L);
        this.memstore = new MemStoreWrapper(context, this.fs, this.table, this.family, new DefaultMemStore(), this.cacheConfig);
        this.compactionBegin = this.conf.getLong("hbase.mob.sweep.tool.compaction.start.date", 0L);
        this.mobTableDir = FSUtils.getTableDir(MobUtils.getMobHome(this.conf), tn);
    }

    private SweepPartition createPartition(SweepPartitionId id, Reducer.Context context) throws IOException {
        return new SweepPartition(id, context);
    }

    public void run(Reducer.Context context) throws IOException, InterruptedException {
        String jobId = context.getConfiguration().get("mob.compaction.id");
        String sweeperNode = context.getConfiguration().get("mob.compaction.sweep.node");
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(context.getConfiguration(), jobId, (Abortable)new MobZookeeper.DummyMobAbortable());
        FSDataOutputStream fout = null;
        try {
            SweepJobNodeTracker tracker = new SweepJobNodeTracker(zkw, sweeperNode, jobId);
            tracker.start();
            this.setup(context);
            String dir = this.conf.get("mob.compaction.visited.dir");
            Path nameFilePath = new Path(dir, UUID.randomUUID().toString().replace("-", ""));
            fout = !this.fs.exists(nameFilePath) ? this.fs.create(nameFilePath, true) : this.fs.append(nameFilePath);
            this.writer = SequenceFile.createWriter((Configuration)context.getConfiguration(), (FSDataOutputStream)fout, String.class, String.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null);
            SweepPartition partition = null;
            while (context.nextKey()) {
                Text key = (Text)context.getCurrentKey();
                String keyString = key.toString();
                SweepPartitionId id = SweepPartitionId.create(keyString);
                if (null == partition || !id.equals(partition.getId())) {
                    if (null != partition) {
                        partition.close();
                    }
                    partition = this.createPartition(id, context);
                }
                if (partition == null) continue;
                partition.execute(key, context.getValues());
            }
            if (null != partition) {
                partition.close();
            }
            this.writer.hflush();
        }
        catch (KeeperException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.cleanup(context);
                zkw.close();
                if (this.writer != null) {
                    IOUtils.closeStream((Closeable)this.writer);
                }
                if (fout != null) {
                    IOUtils.closeStream(fout);
                }
                if (this.table != null) {
                    try {
                        this.table.close();
                    }
                    catch (IOException e2) {
                        LOG.warn((Object)e2);
                    }
                }
                throw throwable;
            }
        }
        this.cleanup(context);
        zkw.close();
        if (this.writer != null) {
            IOUtils.closeStream((Closeable)this.writer);
        }
        if (fout != null) {
            IOUtils.closeStream((Closeable)fout);
        }
        if (this.table != null) {
            try {
                this.table.close();
            }
            catch (IOException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private static class MobFileStatus {
        private FileStatus fileStatus;
        private int validSize;
        private long size;
        private float compactionRatio = 0.5f;
        private long compactionMergeableSize = 0x8000000L;

        public MobFileStatus(FileStatus fileStatus, float compactionRatio, long compactionMergeableSize) {
            this.fileStatus = fileStatus;
            this.size = fileStatus.getLen();
            this.validSize = 0;
            this.compactionRatio = compactionRatio;
            this.compactionMergeableSize = compactionMergeableSize;
        }

        public void addValidSize(int size) {
            this.validSize += size;
        }

        public boolean needClean() {
            return (float)this.validSize < this.compactionRatio * (float)this.size;
        }

        public boolean needMerge() {
            return this.size < this.compactionMergeableSize;
        }

        public FileStatus getFileStatus() {
            return this.fileStatus;
        }
    }

    public static class SweepPartitionId {
        private String date;
        private String startKey;

        public SweepPartitionId(MobFileName fileName) {
            this.date = fileName.getDate();
            this.startKey = fileName.getStartKey();
        }

        public SweepPartitionId(String date, String startKey) {
            this.date = date;
            this.startKey = startKey;
        }

        public static SweepPartitionId create(String key) {
            return new SweepPartitionId(MobFileName.create(key));
        }

        public boolean equals(Object anObject) {
            SweepPartitionId another;
            if (this == anObject) {
                return true;
            }
            return anObject instanceof SweepPartitionId && this.date.equals((another = (SweepPartitionId)anObject).getDate()) && this.startKey.equals(another.getStartKey());
        }

        public String getDate() {
            return this.date;
        }

        public String getStartKey() {
            return this.startKey;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setStartKey(String startKey) {
            this.startKey = startKey;
        }
    }

    static class PathPrefixFilter
    implements PathFilter {
        private final String prefix;

        public PathPrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(Path path) {
            return path.getName().startsWith(this.prefix, 0);
        }
    }

    public class SweepPartition {
        private final SweepPartitionId id;
        private final Reducer.Context context;
        private boolean memstoreUpdated = false;
        private boolean mergeSmall = false;
        private final Map<String, MobFileStatus> fileStatusMap = new HashMap<String, MobFileStatus>();
        private final List<Path> toBeDeleted = new ArrayList<Path>();

        public SweepPartition(SweepPartitionId id, Reducer.Context context) throws IOException {
            this.id = id;
            this.context = context;
            SweepReducer.this.memstore.setPartitionId(id);
            this.init();
        }

        public SweepPartitionId getId() {
            return this.id;
        }

        private void init() throws IOException {
            FileStatus[] fileStats = this.listStatus(SweepReducer.this.familyDir, this.id.getStartKey());
            if (null == fileStats) {
                return;
            }
            int smallFileCount = 0;
            float compactionRatio = SweepReducer.this.conf.getFloat("hbase.mob.sweep.tool.compaction.ratio", 0.5f);
            long compactionMergeableSize = SweepReducer.this.conf.getLong("hbase.mob.sweep.tool.compaction.mergeable.size", 0x8000000L);
            for (FileStatus fileStat : fileStats) {
                MobFileStatus mobFileStatus = null;
                if (HFileLink.isHFileLink(fileStat.getPath())) continue;
                mobFileStatus = new MobFileStatus(fileStat, compactionRatio, compactionMergeableSize);
                if (mobFileStatus.needMerge()) {
                    ++smallFileCount;
                }
                this.fileStatusMap.put(fileStat.getPath().getName(), mobFileStatus);
            }
            if (smallFileCount >= 2) {
                this.mergeSmall = true;
            }
        }

        public void close() throws IOException {
            if (null == this.id) {
                return;
            }
            if (this.memstoreUpdated) {
                SweepReducer.this.memstore.flushMemStore();
            }
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(this.toBeDeleted.size());
            for (Path path : this.toBeDeleted) {
                LOG.info((Object)("[In Partition close] Delete the file " + path + " in partition close"));
                storeFiles.add(new StoreFile(SweepReducer.this.fs, path, SweepReducer.this.conf, SweepReducer.this.cacheConfig, BloomType.NONE));
            }
            if (!storeFiles.isEmpty()) {
                try {
                    MobUtils.removeMobFiles(SweepReducer.this.conf, SweepReducer.this.fs, SweepReducer.this.table.getName(), SweepReducer.this.mobTableDir, SweepReducer.this.family.getName(), storeFiles);
                    this.context.getCounter((Enum)SweepJob.SweepCounter.FILE_TO_BE_MERGE_OR_CLEAN).increment((long)storeFiles.size());
                }
                catch (IOException e) {
                    LOG.error((Object)("Fail to archive the store files " + storeFiles), (Throwable)e);
                }
                storeFiles.clear();
            }
            this.fileStatusMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Text fileName, Iterable<KeyValue> values) throws IOException {
            if (null == values) {
                return;
            }
            MobFileName mobFileName = MobFileName.create(fileName.toString());
            LOG.info((Object)("[In reducer] The file name: " + fileName.toString()));
            MobFileStatus mobFileStat = this.fileStatusMap.get(mobFileName.getFileName());
            if (null == mobFileStat) {
                LOG.info((Object)"[In reducer] Cannot find the file, probably this record is obsolete");
                return;
            }
            if (SweepReducer.this.compactionBegin - mobFileStat.getFileStatus().getModificationTime() <= SweepReducer.this.mobCompactionDelay) {
                return;
            }
            SweepReducer.this.writer.append((Object)mobFileName.getFileName(), (Object)"");
            HashSet<KeyValue> kvs = new HashSet<KeyValue>();
            for (KeyValue kv : values) {
                if (kv.getValueLength() > 4) {
                    mobFileStat.addValidSize(Bytes.toInt((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)4));
                }
                kvs.add(kv.createKeyOnly(false));
            }
            if (mobFileStat.needClean() || this.mergeSmall && mobFileStat.needMerge()) {
                this.context.getCounter((Enum)SweepJob.SweepCounter.INPUT_FILE_COUNT).increment(1L);
                MobFile file = MobFile.create(SweepReducer.this.fs, new Path(SweepReducer.this.familyDir, mobFileName.getFileName()), SweepReducer.this.conf, SweepReducer.this.cacheConfig);
                StoreFileScanner scanner = null;
                try {
                    KeyValue cell;
                    scanner = file.getScanner();
                    scanner.seek(KeyValue.createFirstOnRow((byte[])HConstants.EMPTY_BYTE_ARRAY));
                    while (null != (cell = scanner.next())) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        KeyValue keyOnly = kv.createKeyOnly(false);
                        if (!kvs.contains(keyOnly)) continue;
                        SweepReducer.this.memstore.addToMemstore(kv);
                        this.memstoreUpdated = true;
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
                this.toBeDeleted.add(mobFileStat.getFileStatus().getPath());
            }
        }

        private FileStatus[] listStatus(Path p, String prefix) throws IOException {
            return SweepReducer.this.fs.listStatus(p, (PathFilter)new PathPrefixFilter(prefix));
        }
    }
}

