/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RateLimiter {
    private long tunit = 1000L;
    private long limit = Long.MAX_VALUE;
    private long avail = Long.MAX_VALUE;

    public void set(long limit, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                throw new RuntimeException("Unsupported NANOSECONDS TimeUnit");
            }
            case MICROSECONDS: {
                throw new RuntimeException("Unsupported MICROSECONDS TimeUnit");
            }
            case MILLISECONDS: {
                this.tunit = 1L;
                break;
            }
            case SECONDS: {
                this.tunit = 1000L;
                break;
            }
            case MINUTES: {
                this.tunit = 60000L;
                break;
            }
            case HOURS: {
                this.tunit = 3600000L;
                break;
            }
            case DAYS: {
                this.tunit = 86400000L;
            }
        }
        this.limit = limit;
        this.avail = limit;
    }

    public String toString() {
        if (this.limit == Long.MAX_VALUE) {
            return "RateLimiter(Bypass)";
        }
        return "RateLimiter(avail=" + this.avail + " limit=" + this.limit + " tunit=" + this.tunit + ")";
    }

    public synchronized void update(RateLimiter other) {
        this.tunit = other.tunit;
        if (this.limit < other.limit) {
            this.avail += other.limit - this.limit;
        }
        this.limit = other.limit;
    }

    public synchronized boolean isBypass() {
        return this.limit == Long.MAX_VALUE;
    }

    public synchronized long getLimit() {
        return this.limit;
    }

    public synchronized long getAvailable() {
        return this.avail;
    }

    public boolean canExecute(long now, long lastTs) {
        return this.canExecute(now, lastTs, 1L);
    }

    public synchronized boolean canExecute(long now, long lastTs, long amount) {
        return this.avail >= amount ? true : this.refill(now, lastTs) >= amount;
    }

    public void consume() {
        this.consume(1L);
    }

    public synchronized void consume(long amount) {
        this.avail -= amount;
    }

    public long waitInterval() {
        return this.waitInterval(1L);
    }

    public synchronized long waitInterval(long amount) {
        return amount <= this.avail ? 0L : amount * this.tunit / this.limit - this.avail * this.tunit / this.limit;
    }

    private long refill(long now, long lastTs) {
        long delta = this.limit * (now - lastTs) / this.tunit;
        if (delta > 0L) {
            this.avail = Math.min(this.limit, this.avail + delta);
        }
        return this.avail;
    }
}

