/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;

@InterfaceAudience.Private
public class OperationStatus {
    static final OperationStatus SUCCESS = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    static final OperationStatus FAILURE = new OperationStatus(HConstants.OperationStatusCode.FAILURE);
    static final OperationStatus NOT_RUN = new OperationStatus(HConstants.OperationStatusCode.NOT_RUN);
    private final HConstants.OperationStatusCode code;
    private final String exceptionMsg;

    public OperationStatus(HConstants.OperationStatusCode code) {
        this(code, "");
    }

    public OperationStatus(HConstants.OperationStatusCode code, String exceptionMsg) {
        this.code = code;
        this.exceptionMsg = exceptionMsg;
    }

    public OperationStatus(HConstants.OperationStatusCode code, Exception e) {
        this.code = code;
        this.exceptionMsg = e == null ? "" : e.getClass().getName() + ": " + e.getMessage();
    }

    public HConstants.OperationStatusCode getOperationStatusCode() {
        return this.code;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }
}

