/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WriterBase;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class ProtobufLogWriter
extends WriterBase {
    private final Log LOG = LogFactory.getLog(this.getClass());
    protected FSDataOutputStream output;
    protected Codec.Encoder cellEncoder;
    protected WALCellCodec.ByteStringCompressor compressor;
    private boolean trailerWritten;
    private WALProtos.WALTrailer trailer;
    private int trailerWarnSize;

    protected WALCellCodec getCodec(Configuration conf, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, null, compressionContext);
    }

    protected WALProtos.WALHeader buildWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        if (!builder.hasWriterClsName()) {
            builder.setWriterClsName(ProtobufLogWriter.class.getSimpleName());
        }
        if (!builder.hasCellCodecClsName()) {
            builder.setCellCodecClsName(WALCellCodec.getWALCellCodecClass(conf));
        }
        return builder.build();
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable) throws IOException {
        super.init(fs, path, conf, overwritable);
        assert (this.output == null);
        boolean doCompress = this.initializeCompressionContext(conf, path);
        this.trailerWarnSize = conf.getInt("hbase.regionserver.waltrailer.warn.size", 0x100000);
        int bufferSize = FSUtils.getDefaultBufferSize(fs);
        short replication = (short)conf.getInt("hbase.regionserver.hlog.replication", (int)FSUtils.getDefaultReplication(fs, path));
        long blockSize = conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(fs, path));
        this.output = fs.createNonRecursive(path, overwritable, bufferSize, replication, blockSize, null);
        this.output.write(ProtobufLogReader.PB_WAL_MAGIC);
        boolean doTagCompress = doCompress && conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true);
        this.buildWALHeader(conf, WALProtos.WALHeader.newBuilder().setHasCompression(doCompress).setHasTagCompression(doTagCompress)).writeDelimitedTo((OutputStream)this.output);
        this.initAfterHeader(doCompress);
        this.trailer = WALProtos.WALTrailer.newBuilder().build();
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Initialized protobuf WAL=" + path + ", compression=" + doCompress));
        }
    }

    protected void initAfterHeader(boolean doCompress) throws IOException {
        WALCellCodec codec = this.getCodec(this.conf, this.compressionContext);
        this.cellEncoder = codec.getEncoder((OutputStream)this.output);
        if (doCompress) {
            this.compressor = codec.getByteStringCompressor();
        }
    }

    @Override
    public void append(HLog.Entry entry) throws IOException {
        entry.setCompressionContext(this.compressionContext);
        entry.getKey().getBuilder(this.compressor).setFollowingKvCount(entry.getEdit().size()).build().writeDelimitedTo((OutputStream)this.output);
        for (KeyValue kv : entry.getEdit().getKeyValues()) {
            this.cellEncoder.write((Cell)kv);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            try {
                if (!this.trailerWritten) {
                    this.writeWALTrailer();
                }
                this.output.close();
            }
            catch (NullPointerException npe) {
                this.LOG.warn((Object)npe);
            }
            this.output = null;
        }
    }

    protected WALProtos.WALTrailer buildWALTrailer(WALProtos.WALTrailer.Builder builder) {
        return builder.build();
    }

    private void writeWALTrailer() {
        try {
            int trailerSize = 0;
            if (this.trailer == null) {
                this.LOG.warn((Object)"WALTrailer is null. Continuing with default.");
                this.trailer = this.buildWALTrailer(WALProtos.WALTrailer.newBuilder());
                trailerSize = this.trailer.getSerializedSize();
            } else {
                trailerSize = this.trailer.getSerializedSize();
                if (trailerSize > this.trailerWarnSize) {
                    this.LOG.warn((Object)("Please investigate WALTrailer usage. Trailer size > maximum size : " + trailerSize + " > " + this.trailerWarnSize));
                }
            }
            this.trailer.writeTo((OutputStream)this.output);
            this.output.writeInt(trailerSize);
            this.output.write(ProtobufLogReader.PB_WAL_COMPLETE_MAGIC);
            this.trailerWritten = true;
        }
        catch (IOException ioe) {
            this.LOG.error((Object)"Got IOException while writing trailer", (Throwable)ioe);
        }
    }

    @Override
    public void sync() throws IOException {
        try {
            this.output.flush();
            this.output.sync();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    @Override
    public long getLength() throws IOException {
        try {
            return this.output.getPos();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    public FSDataOutputStream getStream() {
        return this.output;
    }

    @Override
    public void setWALTrailer(WALProtos.WALTrailer walTrailer) {
        this.trailer = walTrailer;
    }
}

