/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Time;

class BlockPoolSlice {
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final File finalizedDir;
    private final File rbwDir;
    private final File tmpDir;
    private static final String DU_CACHE_FILE = "dfsUsed";
    private volatile boolean dfsUsedSaved = false;
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final DU dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.currentDir = new File(bpDir, "current");
        this.finalizedDir = new File(this.currentDir, "finalized");
        if (!this.finalizedDir.exists() && !this.finalizedDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + this.finalizedDir);
        }
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            FileUtil.fullyDelete((File)this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        if (!this.rbwDir.mkdirs() && !this.rbwDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.rbwDir.toString());
        }
        if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
        }
        this.dfsUsage = new DU(bpDir, conf, this.loadDfsUsed());
        this.dfsUsage.start();
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                if (!BlockPoolSlice.this.dfsUsedSaved) {
                    BlockPoolSlice.this.saveDfsUsed();
                }
            }
        }, 30);
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    void decDfsUsed(long value) {
        this.dfsUsage.decDfsUsed(value);
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadDfsUsed() {
        Scanner sc;
        try {
            sc = new Scanner(new File(this.currentDir, DU_CACHE_FILE));
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedDfsUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && Time.now() - mtime < 600000L) {
                FsDatasetImpl.LOG.info((Object)("Cached dfsUsed found for " + this.currentDir + ": " + cachedDfsUsed));
                long l = cachedDfsUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDfsUsed() {
        FileWriter out;
        block5: {
            File outFile = new File(this.currentDir, DU_CACHE_FILE);
            if (outFile.exists() && !outFile.delete()) {
                FsDatasetImpl.LOG.warn((Object)("Failed to delete old dfsUsed file in " + outFile.getParent()));
            }
            out = null;
            try {
                long used = this.getDfsUsed();
                if (used <= 0L) break block5;
                out = new FileWriter(outFile);
                out.write(Long.toString(used) + " " + Long.toString(Time.now()));
                out.flush();
                out.close();
                out = null;
            }
            catch (IOException ioe) {
                try {
                    FsDatasetImpl.LOG.warn((Object)("Failed to write dfsUsed to " + outFile), (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
                    throw throwable;
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File addBlock(Block b, File f) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        if (!blockDir.exists() && !blockDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + blockDir);
        }
        File blockFile = FsDatasetImpl.moveBlockFiles(b, f, blockDir);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
        return blockFile;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDirs((File)this.finalizedDir);
        DiskChecker.checkDir((File)this.tmpDir);
        DiskChecker.checkDir((File)this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap) throws IOException {
        this.addToReplicasMap(volumeMap, this.finalizedDir, true);
        this.addToReplicasMap(volumeMap, this.rbwDir, false);
    }

    File recoverTempUnlinkedBlock(File unlinkedTmp) throws IOException {
        File blockFile = FsDatasetUtil.getOrigFile(unlinkedTmp);
        if (blockFile.exists()) {
            if (!unlinkedTmp.delete()) {
                throw new IOException("Unable to cleanup unlinked tmp file " + unlinkedTmp);
            }
            return null;
        }
        if (!unlinkedTmp.renameTo(blockFile)) {
            throw new IOException("Unable to rename unlinked tmp file " + unlinkedTmp);
        }
        return blockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToReplicasMap(ReplicaMap volumeMap, File dir, boolean isFinalized) throws IOException {
        File[] files;
        for (File file : files = FileUtil.listFiles((File)dir)) {
            if (file.isDirectory()) {
                this.addToReplicasMap(volumeMap, file, isFinalized);
            }
            if (isFinalized && FsDatasetUtil.isUnlinkTmpFile(file) && (file = this.recoverTempUnlinkedBlock(file)) == null || !Block.isBlockFilename(file)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(files, file);
            long blockId = Block.filename2id(file.getName());
            ReplicaInfo newReplica = null;
            if (isFinalized) {
                newReplica = new FinalizedReplica(blockId, file.length(), genStamp, this.volume, file.getParentFile());
            } else {
                boolean loadRwr = true;
                File restartMeta = new File(file.getParent() + File.pathSeparator + "." + file.getName() + ".restart");
                Scanner sc = null;
                try {
                    sc = new Scanner(restartMeta);
                    if (sc.hasNextLong() && sc.nextLong() > Time.now()) {
                        newReplica = new ReplicaBeingWritten(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile(), null);
                        loadRwr = false;
                    }
                    sc.close();
                    if (!restartMeta.delete()) {
                        FsDatasetImpl.LOG.warn((Object)("Failed to delete restart meta file: " + restartMeta.getPath()));
                    }
                }
                catch (FileNotFoundException fnfe) {
                }
                finally {
                    if (sc != null) {
                        sc.close();
                    }
                }
                if (loadRwr) {
                    newReplica = new ReplicaWaitingToBeRecovered(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile());
                }
            }
            ReplicaInfo oldReplica = volumeMap.add(this.bpid, newReplica);
            if (oldReplica == null) continue;
            FsDatasetImpl.LOG.warn((Object)("Two block files with the same block id exist on disk: " + oldReplica.getBlockFile() + " and " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long validateIntegrityAndSetLength(File blockFile, long genStamp) {
        long l;
        FileInputStream blockIn;
        DataInputStream checksumIn;
        block16: {
            long l2;
            block14: {
                checksumIn = null;
                blockIn = null;
                try {
                    int checksumSize;
                    DataChecksum checksum;
                    int bytesPerChecksum;
                    long numChunks;
                    File metaFile = FsDatasetUtil.getMetaFile(blockFile, genStamp);
                    long blockFileLen = blockFile.length();
                    long metaFileLen = metaFile.length();
                    int crcHeaderLen = DataChecksum.getChecksumHeaderSize();
                    if (!blockFile.exists() || blockFileLen == 0L || !metaFile.exists() || metaFileLen < (long)crcHeaderLen) {
                        long l3 = 0L;
                        return l3;
                    }
                    checksumIn = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), HdfsConstants.IO_FILE_BUFFER_SIZE));
                    BlockMetadataHeader header = BlockMetadataHeader.readHeader(checksumIn);
                    short version = header.getVersion();
                    if (version != 1) {
                        FsDatasetImpl.LOG.warn((Object)("Wrong version (" + version + ") for metadata file " + metaFile + " ignoring ..."));
                    }
                    if ((numChunks = Math.min((blockFileLen + (long)(bytesPerChecksum = (checksum = header.getChecksum()).getBytesPerChecksum()) - 1L) / (long)bytesPerChecksum, (metaFileLen - (long)crcHeaderLen) / (long)(checksumSize = checksum.getChecksumSize()))) == 0L) {
                        l2 = 0L;
                        IOUtils.closeStream((Closeable)checksumIn);
                        break block14;
                    }
                    IOUtils.skipFully((InputStream)checksumIn, (long)((numChunks - 1L) * (long)checksumSize));
                    blockIn = new FileInputStream(blockFile);
                    long lastChunkStartPos = (numChunks - 1L) * (long)bytesPerChecksum;
                    IOUtils.skipFully((InputStream)blockIn, (long)lastChunkStartPos);
                    int lastChunkSize = (int)Math.min((long)bytesPerChecksum, blockFileLen - lastChunkStartPos);
                    byte[] buf = new byte[lastChunkSize + checksumSize];
                    checksumIn.readFully(buf, lastChunkSize, checksumSize);
                    IOUtils.readFully((InputStream)blockIn, (byte[])buf, (int)0, (int)lastChunkSize);
                    checksum.update(buf, 0, lastChunkSize);
                    long validFileLength = checksum.compare(buf, lastChunkSize) ? lastChunkStartPos + (long)lastChunkSize : lastChunkStartPos;
                    if (blockFile.length() > validFileLength) {
                        RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
                        try {
                            blockRAF.setLength(validFileLength);
                        }
                        finally {
                            blockRAF.close();
                        }
                    }
                    l = validFileLength;
                    IOUtils.closeStream((Closeable)checksumIn);
                    break block16;
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.warn((Object)e);
                    long l4 = 0L;
                    return l4;
                }
            }
            IOUtils.closeStream(blockIn);
            return l2;
        }
        IOUtils.closeStream((Closeable)blockIn);
        return l;
        finally {
            IOUtils.closeStream(checksumIn);
            IOUtils.closeStream(blockIn);
        }
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown() {
        this.saveDfsUsed();
        this.dfsUsedSaved = true;
        this.dfsUsage.shutdown();
    }
}

