/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class INodeWithAdditionalFields
extends INode
implements LightWeightGSet.LinkedElement {
    private final long id;
    private byte[] name = null;
    private long permission = 0L;
    private long modificationTime = 0L;
    private long accessTime = 0L;
    private LightWeightGSet.LinkedElement next = null;
    private static final INode.Feature[] EMPTY_FEATURE = new INode.Feature[0];
    protected INode.Feature[] features = EMPTY_FEATURE;

    private INodeWithAdditionalFields(INode parent, long id, byte[] name, long permission, long modificationTime, long accessTime) {
        super(parent);
        this.id = id;
        this.name = name;
        this.permission = permission;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
    }

    INodeWithAdditionalFields(long id, byte[] name, PermissionStatus permissions, long modificationTime, long accessTime) {
        this(null, id, name, PermissionStatusFormat.toLong(permissions), modificationTime, accessTime);
    }

    INodeWithAdditionalFields(INodeWithAdditionalFields other) {
        this(other.getParentReference() != null ? other.getParentReference() : other.getParent(), other.getId(), other.getLocalNameBytes(), other.permission, other.modificationTime, other.accessTime);
    }

    public void setNext(LightWeightGSet.LinkedElement next) {
        this.next = next;
    }

    public LightWeightGSet.LinkedElement getNext() {
        return this.next;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final byte[] getLocalNameBytes() {
        return this.name;
    }

    @Override
    public final void setLocalName(byte[] name) {
        this.name = name;
    }

    final void clonePermissionStatus(INodeWithAdditionalFields that) {
        this.permission = that.permission;
    }

    @Override
    final PermissionStatus getPermissionStatus(int snapshotId) {
        return new PermissionStatus(this.getUserName(snapshotId), this.getGroupName(snapshotId), this.getFsPermission(snapshotId));
    }

    final void updatePermissionStatus(PermissionStatusFormat f, long n) {
        this.permission = f.BITS.combine(n, this.permission);
    }

    @Override
    public final String getUserName(int snapshotId) {
        return AuthorizationProvider.get().getUser(this, snapshotId);
    }

    @Override
    final void setUser(String user) {
        AuthorizationProvider.get().setUser(this, user);
    }

    @Override
    public final String getGroupName(int snapshotId) {
        return AuthorizationProvider.get().getGroup(this, snapshotId);
    }

    @Override
    final void setGroup(String group) {
        AuthorizationProvider.get().setGroup(this, group);
    }

    @Override
    public final FsPermission getFsPermission(int snapshotId) {
        return AuthorizationProvider.get().getFsPermission(this, snapshotId);
    }

    @Override
    public final short getFsPermissionShort() {
        return PermissionStatusFormat.getMode(this.permission);
    }

    @Override
    void setPermission(FsPermission permission) {
        AuthorizationProvider.get().setPermission(this, permission);
    }

    @Override
    public long getPermissionLong() {
        return this.permission;
    }

    @Override
    public final AclFeature getAclFeature(int snapshotId) {
        return AuthorizationProvider.get().getAclFeature(this, snapshotId);
    }

    @Override
    final long getModificationTime(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getModificationTime();
        }
        return this.modificationTime;
    }

    @Override
    public final INode updateModificationTime(long mtime, int latestSnapshotId) throws QuotaExceededException {
        Preconditions.checkState((boolean)this.isDirectory());
        if (mtime <= this.modificationTime) {
            return this;
        }
        return this.setModificationTime(mtime, latestSnapshotId);
    }

    final void cloneModificationTime(INodeWithAdditionalFields that) {
        this.modificationTime = that.modificationTime;
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    @Override
    final long getAccessTime(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getAccessTime();
        }
        return this.accessTime;
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    protected void addFeature(INode.Feature f) {
        int size = this.features.length;
        INode.Feature[] arr = new INode.Feature[size + 1];
        if (size != 0) {
            System.arraycopy(this.features, 0, arr, 0, size);
        }
        arr[size] = f;
        this.features = arr;
    }

    protected void removeFeature(INode.Feature f) {
        int size = this.features.length;
        Preconditions.checkState((size > 0 ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
        if (size == 1) {
            Preconditions.checkState((this.features[0] == f ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
            this.features = EMPTY_FEATURE;
            return;
        }
        INode.Feature[] arr = new INode.Feature[size - 1];
        int j = 0;
        boolean overflow = false;
        for (INode.Feature f1 : this.features) {
            if (f1 == f) continue;
            if (j == size - 1) {
                overflow = true;
                break;
            }
            arr[j++] = f1;
        }
        Preconditions.checkState((!overflow && j == size - 1 ? 1 : 0) != 0, (Object)("Feature " + f.getClass().getSimpleName() + " not found."));
        this.features = arr;
    }

    protected <T extends INode.Feature> T getFeature(Class<? extends INode.Feature> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0);
        for (INode.Feature f : this.features) {
            if (!clazz.isAssignableFrom(f.getClass())) continue;
            INode.Feature ret = f;
            return (T)ret;
        }
        return null;
    }

    @Override
    public void removeAclFeature() {
        AuthorizationProvider.get().removeAclFeature(this);
    }

    @Override
    public void addAclFeature(AclFeature f) {
        AuthorizationProvider.get().addAclFeature(this, f);
    }

    @Override
    XAttrFeature getXAttrFeature(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getXAttrFeature();
        }
        return (XAttrFeature)this.getFeature(XAttrFeature.class);
    }

    @Override
    public void removeXAttrFeature() {
        XAttrFeature f = this.getXAttrFeature();
        Preconditions.checkNotNull((Object)f);
        this.removeFeature(f);
    }

    @Override
    public void addXAttrFeature(XAttrFeature f) {
        XAttrFeature f1 = this.getXAttrFeature();
        Preconditions.checkState((f1 == null ? 1 : 0) != 0, (Object)"Duplicated XAttrFeature");
        this.addFeature(f);
    }

    public final INode.Feature[] getFeatures() {
        return this.features;
    }

    static enum PermissionStatusFormat {
        MODE(null, 16),
        GROUP(PermissionStatusFormat.MODE.BITS, 25),
        USER(PermissionStatusFormat.GROUP.BITS, 23);

        final LongBitFormat BITS;

        private PermissionStatusFormat(LongBitFormat previous, int length) {
            this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
        }

        static String getUser(long permission) {
            int n = (int)PermissionStatusFormat.USER.BITS.retrieve(permission);
            return SerialNumberManager.INSTANCE.getUser(n);
        }

        static String getGroup(long permission) {
            int n = (int)PermissionStatusFormat.GROUP.BITS.retrieve(permission);
            return SerialNumberManager.INSTANCE.getGroup(n);
        }

        static short getMode(long permission) {
            return (short)PermissionStatusFormat.MODE.BITS.retrieve(permission);
        }

        static long toLong(PermissionStatus ps) {
            long permission = 0L;
            int user = SerialNumberManager.INSTANCE.getUserSerialNumber(ps.getUserName());
            permission = PermissionStatusFormat.USER.BITS.combine(user, permission);
            int group = SerialNumberManager.INSTANCE.getGroupSerialNumber(ps.getGroupName());
            permission = PermissionStatusFormat.GROUP.BITS.combine(group, permission);
            short mode = ps.getPermission().toShort();
            permission = PermissionStatusFormat.MODE.BITS.combine(mode, permission);
            return permission;
        }
    }
}

