/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.utils;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.platform.web.http.messages.Messages;

public class FileUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String ENCODED_PATH_SEPARATOR = ":";
    private static final Log logger = LogFactory.getLog(FileUtils.class);

    public static String idToPath(String pathId) {
        if (pathId.contains(PATH_SEPARATOR)) {
            logger.warn((Object)Messages.getInstance().getString("FileResource.ILLEGAL_PATHID", new Object[]{pathId}));
        }
        String path = pathId.replaceAll(PATH_SEPARATOR, ENCODED_PATH_SEPARATOR);
        if (!(path = RepositoryPathEncoder.decodeRepositoryPath((String)path)).startsWith(PATH_SEPARATOR)) {
            path = PATH_SEPARATOR + path;
        }
        return path;
    }

    public static boolean containsReservedCharacter(String path, char[] reserved) {
        while (!path.isEmpty()) {
            String name = FilenameUtils.getName((String)path);
            if (StringUtils.containsAny((String)name, (char[])reserved)) {
                return true;
            }
            path = FilenameUtils.getPathNoEndSeparator((String)path);
        }
        return false;
    }

    public static String[] convertCommaSeparatedStringToArray(String stringToConvert) {
        if (stringToConvert == null || stringToConvert.isEmpty()) {
            throw new IllegalArgumentException("String cannot be null or empty");
        }
        return stringToConvert.split("[,]");
    }
}

