/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GetResource
extends ServletBase {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(GetResource.class);

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            String resourcePath;
            IPentahoSession session = this.getPentahoSession(request);
            String resource = request.getParameter("resource");
            if (resource == null || StringUtil.doesPathContainParentPathSegment((String)resource)) {
                this.error(Messages.getInstance().getErrorString("GetResource.ERROR_0001_RESOURCE_PARAMETER_MISSING"));
                response.setStatus(503);
                return;
            }
            String resLower = resource.toLowerCase();
            if (resLower.endsWith(".xsl")) {
                resourcePath = "system/custom/xsl/" + resource;
            } else if (resLower.endsWith(".mondrian.xml")) {
                resourcePath = resource;
            } else if (resLower.endsWith(".jpg") || resLower.endsWith(".jpeg") || resLower.endsWith(".gif") || resLower.endsWith(".png") || resLower.endsWith(".bmp")) {
                resourcePath = resource;
            } else if (resLower.endsWith(".jar")) {
                resourcePath = resource;
            } else {
                this.error(Messages.getInstance().getErrorString("GetResource.ERROR_0002_INVALID_FILE", new Object[]{resource}));
                response.setStatus(503);
                return;
            }
            ActionSequenceResource asqr = new ActionSequenceResource("", 1, "", resourcePath);
            InputStream in = asqr.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
            if (in == null) {
                this.error(Messages.getInstance().getErrorString("GetResource.ERROR_0003_RESOURCE_MISSING", new Object[]{resourcePath}));
                response.setStatus(503);
                return;
            }
            String mimeType = this.getServletContext().getMimeType(resourcePath);
            String resourceName = resourcePath;
            if (resourcePath.indexOf("/") != -1) {
                resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            }
            response.setHeader("content-disposition", "attachment;filename=" + resourceName);
            if (null == mimeType || mimeType.length() <= 0) {
                response.setContentType("image/png");
            } else {
                response.setContentType(mimeType);
            }
            response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            response.setHeader("expires", "0");
            ServletOutputStream out = response.getOutputStream();
            try {
                byte[] buf = new byte[1024];
                int count = 0;
                int totalBytes = 0;
                while ((count = in.read(buf)) >= 0) {
                    out.write(buf, 0, count);
                    totalBytes += count;
                }
                response.setContentLength(totalBytes);
            }
            finally {
                in.close();
                out.close();
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }
}

