/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.Entry;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.core.security.authorization.acl.MagicAceDefinition;
import org.apache.jackrabbit.core.security.authorization.acl.MagicGroup;
import org.apache.jackrabbit.core.security.authorization.acl.MagicPrincipal;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntry;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntryFilter;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository2.unified.jcr.IAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.util.Assert;

public class PentahoEntryCollector
extends EntryCollector {
    private static final Logger log = LoggerFactory.getLogger(PentahoEntryCollector.class);
    private List<MagicAceDefinition> magicAceDefinitions = new ArrayList<MagicAceDefinition>();

    public PentahoEntryCollector(SessionImpl systemSession, NodeId rootID, Map configuration) throws RepositoryException {
        super(systemSession, rootID);
        this.parseMagicAceDefinitions(configuration);
    }

    protected void parseMagicAceDefinitions(Map configuration) throws RepositoryException {
        String value;
        int i = 0;
        while ((value = (String)configuration.get("magicAceDefinition" + i)) != null) {
            MagicAceDefinition pam = this.parseMagicAceDefinition(value);
            this.magicAceDefinitions.add(pam);
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("magic ACE definitions: " + this.magicAceDefinitions);
        }
    }

    protected MagicAceDefinition parseMagicAceDefinition(String value) throws RepositoryException {
        String[] tokens = value.split("\\;");
        String path = tokens[0];
        String logicalRole = tokens[1];
        String privilegeString = tokens[2];
        boolean applyToTarget = Boolean.valueOf(tokens[3]);
        boolean applyToChildren = Boolean.valueOf(tokens[4]);
        boolean applyToAncestors = Boolean.valueOf(tokens[5]);
        String[] exceptChildren = null;
        if (tokens.length > 6) {
            exceptChildren = new String[tokens.length - 6];
            for (int i = 6; i < tokens.length; ++i) {
                exceptChildren[i - 6] = tokens[i];
            }
        }
        String[] privilegeTokens = privilegeString.split("\\,");
        ArrayList<Privilege> privileges = new ArrayList<Privilege>(privilegeTokens.length);
        for (String privilegeToken : privilegeTokens) {
            privileges.add(this.systemSession.getAccessControlManager().privilegeFromName(privilegeToken));
        }
        return new MagicAceDefinition(path, logicalRole, privileges.toArray(new Privilege[0]), applyToTarget, applyToChildren, applyToAncestors, exceptChildren);
    }

    protected NodeImpl findAccessControlledNode(NodeImpl node) throws RepositoryException {
        NodeImpl currentNode = node;
        while (!ACLProvider.isAccessControlled((NodeImpl)currentNode)) {
            currentNode = (NodeImpl)currentNode.getParent();
        }
        return currentNode;
    }

    protected NodeImpl findNonInheritingNode(NodeImpl node) throws RepositoryException {
        NodeImpl currentNode = node;
        while (true) {
            NodeImpl aclNode;
            String path = (aclNode = (currentNode = this.findAccessControlledNode(currentNode)).getNode(N_POLICY)) != null ? aclNode.getParent().getPath() : null;
            ACLTemplate acl = new ACLTemplate(aclNode, path, false);
            IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata((Session)this.systemSession, currentNode.getPath(), (AccessControlList)acl);
            if (aclMetadata == null || !aclMetadata.isEntriesInheriting()) break;
            currentNode = (NodeImpl)currentNode.getParent();
        }
        return currentNode;
    }

    protected PentahoEntries getEntries(NodeImpl node) throws RepositoryException {
        NodeImpl currentNode = node;
        if (currentNode.getPath().startsWith("/jcr:system/jcr:versionStorage")) {
            currentNode = this.getVersionable(currentNode);
        }
        currentNode = this.findAccessControlledNode(currentNode);
        ACLTemplate acl = new ACLTemplate(currentNode.getNode(N_POLICY), currentNode.getPath(), false);
        String owner = null;
        IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata((Session)this.systemSession, currentNode.getPath(), (AccessControlList)acl);
        if (aclMetadata != null) {
            owner = aclMetadata.getOwner();
        }
        NodeImpl firstAccessControlledNode = currentNode;
        currentNode = this.findNonInheritingNode(currentNode);
        acl = new ACLTemplate(currentNode.getNode(N_POLICY), currentNode.getPath(), false);
        if (!currentNode.isSame((Item)node)) {
            Privilege removeNodePrivilege = this.systemSession.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode");
            Privilege removeChildNodesPrivilege = this.systemSession.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes");
            for (AccessControlEntry entry : acl.getEntries()) {
                Object[] expandedPrivileges = JcrRepositoryFileAclUtils.expandPrivileges(entry.getPrivileges(), false);
                if (!ArrayUtils.contains((Object[])expandedPrivileges, (Object)removeChildNodesPrivilege) || ArrayUtils.contains((Object[])expandedPrivileges, (Object)removeNodePrivilege)) continue;
                if (acl.addAccessControlEntry(entry.getPrincipal(), new Privilege[]{removeNodePrivilege})) break;
                throw new RuntimeException();
            }
        }
        ACLTemplate ancestorAcl = null;
        if (firstAccessControlledNode.isSame((Item)currentNode) && !this.rootID.equals((Object)currentNode.getNodeId())) {
            NodeImpl ancestorNode = this.findNonInheritingNode((NodeImpl)currentNode.getParent());
            ancestorAcl = new ACLTemplate(ancestorNode.getNode(N_POLICY), ancestorNode.getPath(), false);
        }
        return new PentahoEntries(this.getAcesIncludingMagicAces(currentNode.getPath(), owner, ancestorAcl, acl), null);
    }

    protected NodeImpl getVersionable(NodeImpl node) throws RepositoryException {
        NodeImpl currentNode = node;
        while (!currentNode.isNodeType("nt:versionHistory") && !this.rootID.equals((Object)currentNode.getNodeId())) {
            currentNode = (NodeImpl)currentNode.getParent();
        }
        if (this.rootID.equals((Object)currentNode.getNodeId())) {
            return currentNode;
        }
        return (NodeImpl)this.systemSession.getNodeByIdentifier(((VersionHistory)currentNode).getVersionableIdentifier());
    }

    protected IAuthorizationPolicy getAuthorizationPolicy() {
        IAuthorizationPolicy authorizationPolicy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        if (authorizationPolicy == null) {
            throw new IllegalStateException();
        }
        return authorizationPolicy;
    }

    protected IRoleAuthorizationPolicyRoleBindingDao getRoleBindingDao() {
        return (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
    }

    protected List<PentahoEntry> getAcesIncludingMagicAces(String path, String owner, ACLTemplate ancestorAcl, ACLTemplate acl) throws RepositoryException {
        if (PentahoSessionHolder.getSession() == null || PentahoSessionHolder.getSession().getId() == null || PentahoSessionHolder.getSession().getId().trim().equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("no PentahoSession so no magic ACEs");
            }
            return Collections.emptyList();
        }
        if (owner != null) {
            this.addOwnerAce(owner, acl);
        }
        boolean match = false;
        IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = null;
        try {
            roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.getObjectFactory().get(IRoleAuthorizationPolicyRoleBindingDao.class, "roleAuthorizationPolicyRoleBindingDaoTarget", PentahoSessionHolder.getSession());
        }
        catch (ObjectFactoryException e) {
            e.printStackTrace();
        }
        ITenant tenant = JcrTenantUtils.getTenant();
        for (MagicAceDefinition def : this.magicAceDefinitions) {
            match = false;
            String substitutedPath = MessageFormat.format(def.path, tenant.getRootFolderAbsolutePath());
            if (this.isAllowed(roleBindingDao, def.logicalRole)) {
                if (def.applyToTarget) {
                    match = path.equals(substitutedPath);
                }
                if (!match && def.applyToChildren && (match = path.startsWith(substitutedPath + "/")) && def.exceptChildren != null) {
                    for (String childPath : def.exceptChildren) {
                        String substitutedChildPath = MessageFormat.format(childPath, tenant.getRootFolderAbsolutePath());
                        if (!path.startsWith(substitutedChildPath + "/")) continue;
                        match = false;
                        break;
                    }
                }
                if (!match && def.applyToAncestors) {
                    match = substitutedPath.startsWith(path + "/");
                }
            }
            if (!match) continue;
            MagicPrincipal principal = new MagicPrincipal(JcrTenantUtils.getTenantedUser(PentahoSessionHolder.getSession().getName()));
            acl.addAccessControlEntry((Principal)principal, def.privileges);
        }
        ArrayList<PentahoEntry> acEntries = new ArrayList<PentahoEntry>();
        acEntries.addAll(this.buildPentahoEntries(acl));
        acEntries.addAll(this.getRelevantAncestorAces(ancestorAcl));
        return acEntries;
    }

    protected List<PentahoEntry> getRelevantAncestorAces(ACLTemplate ancestorAcl) throws RepositoryException {
        if (ancestorAcl == null) {
            return Collections.emptyList();
        }
        NodeImpl ancestorNode = (NodeImpl)this.systemSession.getNode(ancestorAcl.getPath());
        PentahoEntries fullEntriesIncludingMagicACEs = this.getEntries(ancestorNode);
        JackrabbitAccessControlManager acMgr = (JackrabbitAccessControlManager)this.systemSession.getAccessControlManager();
        PrivilegeManagerImpl privMrg = (PrivilegeManagerImpl)((JackrabbitWorkspace)this.systemSession.getWorkspace()).getPrivilegeManager();
        Privilege addChildNodesPrivilege = acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes");
        PrivilegeBits addChildNodesPrivilegeBits = privMrg.getBits(new Privilege[]{addChildNodesPrivilege});
        Privilege removeChildNodesPrivilege = acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes");
        PrivilegeBits removeChildNodesPrivilegeBits = privMrg.getBits(new Privilege[]{removeChildNodesPrivilege});
        for (PentahoEntry entry : fullEntriesIncludingMagicACEs.getACEs()) {
            AccessControlEntry[] ancestorACEs;
            ArrayList<Privilege> privs = new ArrayList<Privilege>(2);
            if (entry.getPrivilegeBits().includes(addChildNodesPrivilegeBits)) {
                privs.add(addChildNodesPrivilege);
            }
            if (entry.getPrivilegeBits().includes(removeChildNodesPrivilegeBits)) {
                privs.add(removeChildNodesPrivilege);
            }
            for (AccessControlEntry ace : ancestorACEs = ancestorAcl.getEntries().toArray(new AccessControlEntry[0])) {
                PentahoEntry pe = this.buildPentahoEntry(ancestorNode.getNodeId(), ancestorAcl.getPath(), ace);
                if (!entry.equals(pe)) continue;
                ancestorAcl.removeAccessControlEntry(ace);
            }
            if (privs.isEmpty()) continue;
            LinkedList entries = new LinkedList(ancestorAcl.getEntries());
            for (AccessControlEntry ace : entries) {
                if (!ace.getPrincipal().getName().equals(entry.getPrincipalName())) continue;
                ancestorAcl.removeAccessControlEntry(ace);
            }
            if (ancestorAcl.addAccessControlEntry((Principal)(entry.isGroupEntry() ? new MagicGroup(entry.getPrincipalName()) : new MagicPrincipal(entry.getPrincipalName())), privs.toArray(new Privilege[privs.size()]))) continue;
            throw new RuntimeException();
        }
        return this.buildPentahoEntries(ancestorAcl);
    }

    protected void addOwnerAce(String owner, ACLTemplate acl) throws RepositoryException {
        Principal ownerPrincipal = this.systemSession.getPrincipalManager().getPrincipal(owner);
        if (ownerPrincipal != null) {
            UnknownPrincipal magicPrincipal = null;
            magicPrincipal = ownerPrincipal instanceof Group ? new MagicGroup(JcrTenantUtils.getTenantedUser(ownerPrincipal.getName())) : new MagicPrincipal(JcrTenantUtils.getTenantedUser(ownerPrincipal.getName()));
            acl.addAccessControlEntry((Principal)magicPrincipal, new Privilege[]{this.systemSession.getAccessControlManager().privilegeFromName("jcr:all")});
        } else if (log.isDebugEnabled()) {
            log.debug("PrincipalManager cannot find owner=" + owner);
        }
    }

    protected List collectEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        Object entries;
        LinkedList userAces = new LinkedList();
        LinkedList groupAces = new LinkedList();
        if (node == null) {
            NodeImpl root = (NodeImpl)this.systemSession.getRootNode();
            if (ACLProvider.isRepoAccessControlled((NodeImpl)root)) {
                String path;
                NodeImpl aclNode = root.getNode(N_REPO_POLICY);
                String string = path = aclNode != null ? aclNode.getParent().getPath() : null;
                if (filter instanceof PentahoEntryFilter) {
                    this.filterEntries(filter, PentahoEntry.readEntries(aclNode, path), userAces, groupAces);
                } else {
                    this.filterEntries(filter, Entry.readEntries((NodeImpl)aclNode, (String)path), userAces, groupAces);
                }
            }
        } else {
            entries = this.getEntries(node);
            this.filterEntries(filter, entries.getACEs(), userAces, groupAces);
            NodeId next = entries.getNextId();
            while (next != null) {
                entries = this.getEntries(next);
                this.filterEntries(filter, entries.getACEs(), userAces, groupAces);
                next = entries.getNextId();
            }
        }
        entries = new ArrayList(userAces.size() + groupAces.size());
        entries.addAll(userAces);
        entries.addAll(groupAces);
        return entries;
    }

    protected void filterEntries(EntryFilter filter, List aces, LinkedList userAces, LinkedList groupAces) {
        if (!aces.isEmpty() && filter != null) {
            filter.filterEntries(aces, new List[]{userAces, groupAces});
        }
    }

    protected List<String> getRuntimeRoleNames() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        ArrayList<String> runtimeRoles = new ArrayList<String>();
        Assert.state((pentahoSession != null ? 1 : 0) != 0);
        Authentication authentication = SecurityHelper.getInstance().getAuthentication();
        if (authentication != null) {
            GrantedAuthority[] authorities = authentication.getAuthorities();
            for (int i = 0; i < authorities.length; ++i) {
                runtimeRoles.add(authorities[i].getAuthority());
            }
        }
        return runtimeRoles;
    }

    protected boolean isAllowed(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, String logicalRoleName) throws RepositoryException {
        return roleBindingDao.getBoundLogicalRoleNames((Session)this.systemSession, this.getRuntimeRoleNames()).contains(logicalRoleName);
    }

    private static AccessControlList getACList(AccessControlManager acMgr, String path) throws RepositoryException {
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy acp = it.nextAccessControlPolicy();
            if (!(acp instanceof AccessControlList)) continue;
            return (AccessControlList)acp;
        }
        AccessControlPolicy[] acps = acMgr.getPolicies(path);
        for (int i = 0; i < acps.length; ++i) {
            if (!(acps[i] instanceof AccessControlList)) continue;
            return (AccessControlList)acps[i];
        }
        return null;
    }

    private List<PentahoEntry> buildPentahoEntries(ACLTemplate acl) throws RepositoryException {
        ArrayList<PentahoEntry> aces = new ArrayList<PentahoEntry>();
        if (acl != null && acl.getEntries() != null && acl.getEntries().size() > 0) {
            NodeImpl aclNode = (NodeImpl)this.systemSession.getNode(acl.getPath());
            for (AccessControlEntry ace : acl.getEntries()) {
                aces.add(this.buildPentahoEntry(aclNode.getNodeId(), acl.getPath(), ace));
            }
        }
        return aces;
    }

    private PentahoEntry buildPentahoEntry(NodeId nodeId, String path, AccessControlEntry ace) throws RepositoryException {
        PentahoEntry entry = null;
        if (ace != null) {
            Principal principal = ace.getPrincipal();
            boolean isGroupEntry = principal instanceof Group;
            PrivilegeBits bits = ((ACLTemplate.Entry)ace).getPrivilegeBits();
            boolean isAllow = ((ACLTemplate.Entry)ace).isAllow();
            entry = new PentahoEntry(nodeId, principal.getName(), isGroupEntry, bits, isAllow, path, ((ACLTemplate.Entry)ace).getRestrictions());
        }
        return entry;
    }

    static class PentahoEntries
    extends EntryCollector.Entries {
        private List<PentahoEntry> aces;

        PentahoEntries(List aces, NodeId nextId) {
            super(null, nextId);
            this.aces = aces;
        }

        PentahoEntries(EntryCollector.Entries e) {
            super(e.getACEs(), e.getNextId());
            this.aces = new ArrayList<PentahoEntry>();
        }

        public List getACEs() {
            return this.aces;
        }

        public boolean isEmpty() {
            return this.aces == null || this.aces.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size = ").append(this.getACEs() != null ? this.getACEs().size() : 0).append(", ");
            sb.append("nextNodeId = ").append(this.getNextId());
            return sb.toString();
        }
    }
}

