/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.transform;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.NodeHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.Assert;

public class NodeRepositoryFileDataTransformer
implements ITransformer<NodeRepositoryFileData> {
    protected void createOrUpdateContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, NodeRepositoryFileData data, Node fileNode) throws RepositoryException {
        Node unstructuredNode = null;
        unstructuredNode = fileNode.hasNode(pentahoJcrConstants.getJCR_CONTENT()) ? fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT()) : fileNode.addNode(pentahoJcrConstants.getJCR_CONTENT(), pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        String pattern = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":" + "*";
        NodeIterator nodes = unstructuredNode.getNodes(pattern);
        while (nodes.hasNext()) {
            nodes.nextNode().remove();
        }
        this.internalCreateOrUpdate(session, pentahoJcrConstants, unstructuredNode, data.getNode());
    }

    @Override
    public void createContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, NodeRepositoryFileData data, Node fileNode) throws RepositoryException {
        this.createOrUpdateContentNode(session, pentahoJcrConstants, data, fileNode);
    }

    protected void internalCreateOrUpdate(Session session, PentahoJcrConstants pentahoJcrConstants, Node jcrParentNode, DataNode dataNode) throws RepositoryException {
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        Node jcrNode = null;
        String nodeName = dataNode.getName();
        jcrNode = NodeHelper.hasNode(jcrParentNode, prefix, nodeName = JcrStringHelper.fileNameEncode(nodeName)) ? NodeHelper.getNode(jcrParentNode, prefix, nodeName) : jcrParentNode.addNode(prefix + nodeName, pentahoJcrConstants.getPHO_NT_INTERNALFOLDER());
        block8: for (DataProperty dataProp : dataNode.getProperties()) {
            String propName = dataProp.getName();
            propName = prefix + JcrStringHelper.fileNameEncode(propName);
            switch (dataProp.getType()) {
                case STRING: {
                    jcrNode.setProperty(propName, dataProp.getString());
                    continue block8;
                }
                case BOOLEAN: {
                    jcrNode.setProperty(propName, dataProp.getBoolean());
                    continue block8;
                }
                case DOUBLE: {
                    jcrNode.setProperty(propName, dataProp.getDouble());
                    continue block8;
                }
                case LONG: {
                    jcrNode.setProperty(propName, dataProp.getLong());
                    continue block8;
                }
                case DATE: {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dataProp.getDate());
                    jcrNode.setProperty(propName, cal);
                    continue block8;
                }
                case REF: {
                    jcrNode.setProperty(propName, session.getNodeByIdentifier(dataProp.getRef().getId().toString()));
                    continue block8;
                }
            }
            throw new IllegalArgumentException();
        }
        for (DataNode child : dataNode.getNodes()) {
            this.internalCreateOrUpdate(session, pentahoJcrConstants, jcrNode, child);
        }
    }

    @Override
    public NodeRepositoryFileData fromContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, Node fileNode) throws RepositoryException {
        String pattern;
        Node unstructuredNode = fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT());
        Assert.isTrue((unstructuredNode.getNodes(pattern = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":" + "*").getSize() == 1L ? 1 : 0) != 0);
        Node jcrNode = unstructuredNode.getNodes(pattern).nextNode();
        return new NodeRepositoryFileData(this.internalRead(session, pentahoJcrConstants, jcrNode, null));
    }

    protected DataNode internalRead(Session session, PentahoJcrConstants pentahoJcrConstants, Node jcrNode, DataNode parentDataNode) throws RepositoryException {
        String prefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        String pattern = prefix + "*";
        String nodeName = JcrStringHelper.fileNameDecode(jcrNode.getName().substring(prefix.length()));
        DataNode dataNode = parentDataNode != null ? parentDataNode.addNode(nodeName) : new DataNode(nodeName);
        dataNode.setId((Serializable)((Object)jcrNode.getIdentifier()));
        PropertyIterator props = jcrNode.getProperties(pattern);
        block10: while (props.hasNext()) {
            Property prop = props.nextProperty();
            String propName = JcrStringHelper.fileNameDecode(prop.getName().substring(prefix.length()));
            switch (prop.getType()) {
                case 1: {
                    dataNode.setProperty(propName, prop.getString());
                    continue block10;
                }
                case 6: {
                    dataNode.setProperty(propName, prop.getBoolean());
                    continue block10;
                }
                case 4: {
                    dataNode.setProperty(propName, prop.getDouble());
                    continue block10;
                }
                case 3: {
                    dataNode.setProperty(propName, prop.getLong());
                    continue block10;
                }
                case 5: {
                    dataNode.setProperty(propName, prop.getDate().getTime());
                    continue block10;
                }
                case 9: {
                    try {
                        dataNode.setProperty(propName, new DataNodeRef((Serializable)((Object)prop.getNode().getIdentifier())));
                    }
                    catch (ItemNotFoundException e) {
                        dataNode.setProperty(propName, new DataNodeRef((Serializable)((Object)"REF_MISSING")));
                    }
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        NodeIterator nodes = jcrNode.getNodes(pattern);
        while (nodes.hasNext()) {
            Node child = nodes.nextNode();
            this.internalRead(session, pentahoJcrConstants, child, dataNode);
        }
        return dataNode;
    }

    @Override
    public boolean canRead(String contentType, Class<? extends IRepositoryFileData> clazz) {
        return "node".equals(contentType) && clazz.isAssignableFrom(NodeRepositoryFileData.class);
    }

    @Override
    public boolean canWrite(Class<? extends IRepositoryFileData> clazz) {
        return NodeRepositoryFileData.class.equals(clazz);
    }

    @Override
    public String getContentType() {
        return "node";
    }

    @Override
    public void updateContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, NodeRepositoryFileData data, Node fileNode) throws RepositoryException {
        this.createOrUpdateContentNode(session, pentahoJcrConstants, data, fileNode);
    }
}

