/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.auth;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSSessionCredentials;
import com.cloudera.com.amazonaws.auth.AbstractAWSSigner;
import com.cloudera.com.amazonaws.auth.SigningAlgorithm;
import com.cloudera.com.amazonaws.util.DateUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontSigner
extends AbstractAWSSigner {
    private static final Log log = LogFactory.getLog(CloudFrontSigner.class);

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws AmazonClientException {
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        Date signDate = this.getSignatureDate(this.getTimeOffset(request));
        String date = new DateUtils().formatRfc822Date(signDate);
        request.addHeader("Date", date);
        String canonicalString = date;
        log.debug((Object)("Calculated string to sign:\n\"" + canonicalString + "\""));
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        request.addHeader("Authorization", "AWS " + sanitizedCredentials.getAWSAccessKeyId() + ":" + signature);
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addHeader("x-amz-security-token", credentials.getSessionToken());
    }
}

