/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.datapipeline.model;

import com.cloudera.com.amazonaws.services.datapipeline.model.PipelineObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskObject
implements Serializable {
    private String taskId;
    private String pipelineId;
    private String attemptId;
    private Map<String, PipelineObject> objects;

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public TaskObject withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public TaskObject withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public TaskObject withAttemptId(String attemptId) {
        this.attemptId = attemptId;
        return this;
    }

    public Map<String, PipelineObject> getObjects() {
        if (this.objects == null) {
            this.objects = new HashMap<String, PipelineObject>();
        }
        return this.objects;
    }

    public void setObjects(Map<String, PipelineObject> objects) {
        this.objects = objects;
    }

    public TaskObject withObjects(Map<String, PipelineObject> objects) {
        this.setObjects(objects);
        return this;
    }

    public TaskObject addObjectsEntry(String key, PipelineObject value) {
        if (null == this.objects) {
            this.objects = new HashMap<String, PipelineObject>();
        }
        if (this.objects.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.objects.put(key, value);
        return this;
    }

    public TaskObject clearObjectsEntries() {
        this.objects = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskId() != null) {
            sb.append("TaskId: " + this.getTaskId() + ",");
        }
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getAttemptId() != null) {
            sb.append("AttemptId: " + this.getAttemptId() + ",");
        }
        if (this.getObjects() != null) {
            sb.append("Objects: " + this.getObjects());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getAttemptId() == null ? 0 : this.getAttemptId().hashCode());
        hashCode = 31 * hashCode + (this.getObjects() == null ? 0 : this.getObjects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskObject)) {
            return false;
        }
        TaskObject other = (TaskObject)obj;
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        if (other.getTaskId() != null && !other.getTaskId().equals(this.getTaskId())) {
            return false;
        }
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getAttemptId() == null ^ this.getAttemptId() == null) {
            return false;
        }
        if (other.getAttemptId() != null && !other.getAttemptId().equals(this.getAttemptId())) {
            return false;
        }
        if (other.getObjects() == null ^ this.getObjects() == null) {
            return false;
        }
        return other.getObjects() == null || other.getObjects().equals(this.getObjects());
    }
}

