/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.dynamodbv2.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTableRequestMarshaller
implements Marshaller<Request<UpdateTableRequest>, UpdateTableRequest> {
    @Override
    public Request<UpdateTableRequest> marshall(UpdateTableRequest updateTableRequest) {
        if (updateTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTableRequest> request = new DefaultRequest<UpdateTableRequest>(updateTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateTable";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag globalSecondaryIndexUpdatesList;
            ProvisionedThroughput provisionedThroughput;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(updateTableRequest.getTableName());
            }
            if ((provisionedThroughput = updateTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.key("ProvisionedThroughput");
                jsonWriter.object();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.key("ReadCapacityUnits").value(provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.key("WriteCapacityUnits").value(provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            if (!((globalSecondaryIndexUpdatesList = (ListWithAutoConstructFlag)updateTableRequest.getGlobalSecondaryIndexUpdates()) == null || globalSecondaryIndexUpdatesList.isAutoConstruct() && globalSecondaryIndexUpdatesList.isEmpty())) {
                jsonWriter.key("GlobalSecondaryIndexUpdates");
                jsonWriter.array();
                for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdatesListValue : globalSecondaryIndexUpdatesList) {
                    if (globalSecondaryIndexUpdatesListValue == null) continue;
                    jsonWriter.object();
                    UpdateGlobalSecondaryIndexAction update = globalSecondaryIndexUpdatesListValue.getUpdate();
                    if (update != null) {
                        ProvisionedThroughput provisionedThroughput2;
                        jsonWriter.key("Update");
                        jsonWriter.object();
                        if (update.getIndexName() != null) {
                            jsonWriter.key("IndexName").value(update.getIndexName());
                        }
                        if ((provisionedThroughput2 = update.getProvisionedThroughput()) != null) {
                            jsonWriter.key("ProvisionedThroughput");
                            jsonWriter.object();
                            if (provisionedThroughput2.getReadCapacityUnits() != null) {
                                jsonWriter.key("ReadCapacityUnits").value(provisionedThroughput2.getReadCapacityUnits());
                            }
                            if (provisionedThroughput2.getWriteCapacityUnits() != null) {
                                jsonWriter.key("WriteCapacityUnits").value(provisionedThroughput2.getWriteCapacityUnits());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

