/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.cloudera.com.amazonaws.services.ec2.model.Filter;
import com.cloudera.com.amazonaws.services.ec2.model.transform.DescribeKeyPairsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeKeyPairsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeKeyPairsRequest> {
    private ListWithAutoConstructFlag<String> keyNames;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getKeyNames() {
        if (this.keyNames == null) {
            this.keyNames = new ListWithAutoConstructFlag();
            this.keyNames.setAutoConstruct(true);
        }
        return this.keyNames;
    }

    public void setKeyNames(Collection<String> keyNames) {
        if (keyNames == null) {
            this.keyNames = null;
            return;
        }
        ListWithAutoConstructFlag keyNamesCopy = new ListWithAutoConstructFlag(keyNames.size());
        keyNamesCopy.addAll(keyNames);
        this.keyNames = keyNamesCopy;
    }

    public DescribeKeyPairsRequest withKeyNames(String ... keyNames) {
        if (this.getKeyNames() == null) {
            this.setKeyNames(new ArrayList<String>(keyNames.length));
        }
        for (String value : keyNames) {
            this.getKeyNames().add(value);
        }
        return this;
    }

    public DescribeKeyPairsRequest withKeyNames(Collection<String> keyNames) {
        if (keyNames == null) {
            this.keyNames = null;
        } else {
            ListWithAutoConstructFlag keyNamesCopy = new ListWithAutoConstructFlag(keyNames.size());
            keyNamesCopy.addAll(keyNames);
            this.keyNames = keyNamesCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeKeyPairsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeKeyPairsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeKeyPairsRequest> getDryRunRequest() {
        Request<DescribeKeyPairsRequest> request = new DescribeKeyPairsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyNames() != null) {
            sb.append("KeyNames: " + this.getKeyNames() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyNames() == null ? 0 : this.getKeyNames().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest)obj;
        if (other.getKeyNames() == null ^ this.getKeyNames() == null) {
            return false;
        }
        if (other.getKeyNames() != null && !other.getKeyNames().equals(this.getKeyNames())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

