/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticache.model.transform;

import com.cloudera.com.amazonaws.services.elasticache.model.NodeGroupMember;
import com.cloudera.com.amazonaws.services.elasticache.model.transform.EndpointStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeGroupMemberStaxUnmarshaller
implements Unmarshaller<NodeGroupMember, StaxUnmarshallerContext> {
    private static NodeGroupMemberStaxUnmarshaller instance;

    @Override
    public NodeGroupMember unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeGroupMember nodeGroupMember = new NodeGroupMember();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return nodeGroupMember;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    nodeGroupMember.setCacheClusterId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeId", targetDepth)) {
                    nodeGroupMember.setCacheNodeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadEndpoint", targetDepth)) {
                    nodeGroupMember.setReadEndpoint(EndpointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredAvailabilityZone", targetDepth)) {
                    nodeGroupMember.setPreferredAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CurrentRole", targetDepth)) continue;
                nodeGroupMember.setCurrentRole(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return nodeGroupMember;
    }

    public static NodeGroupMemberStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeGroupMemberStaxUnmarshaller();
        }
        return instance;
    }
}

