/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.importexport.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.importexport.model.CreateJobRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonImportExport");
        request.addParameter("Action", "CreateJob");
        request.addParameter("Version", "2010-06-01");
        if (createJobRequest.getJobType() != null) {
            request.addParameter("JobType", StringUtils.fromString(createJobRequest.getJobType()));
        }
        if (createJobRequest.getManifest() != null) {
            request.addParameter("Manifest", StringUtils.fromString(createJobRequest.getManifest()));
        }
        if (createJobRequest.getManifestAddendum() != null) {
            request.addParameter("ManifestAddendum", StringUtils.fromString(createJobRequest.getManifestAddendum()));
        }
        if (createJobRequest.isValidateOnly() != null) {
            request.addParameter("ValidateOnly", StringUtils.fromBoolean(createJobRequest.isValidateOnly()));
        }
        return request;
    }
}

