/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.opsworks.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.opsworks.model.CreateStackRequest;
import com.cloudera.com.amazonaws.services.opsworks.model.Source;
import com.cloudera.com.amazonaws.services.opsworks.model.StackConfigurationManager;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    @Override
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        if (createStackRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStackRequest> request = new DefaultRequest<CreateStackRequest>(createStackRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateStack";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            Source customCookbooksSource;
            StackConfigurationManager configurationManager;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createStackRequest.getName() != null) {
                jsonWriter.key("Name").value(createStackRequest.getName());
            }
            if (createStackRequest.getRegion() != null) {
                jsonWriter.key("Region").value(createStackRequest.getRegion());
            }
            if (createStackRequest.getVpcId() != null) {
                jsonWriter.key("VpcId").value(createStackRequest.getVpcId());
            }
            if (createStackRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : createStackRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createStackRequest.getServiceRoleArn() != null) {
                jsonWriter.key("ServiceRoleArn").value(createStackRequest.getServiceRoleArn());
            }
            if (createStackRequest.getDefaultInstanceProfileArn() != null) {
                jsonWriter.key("DefaultInstanceProfileArn").value(createStackRequest.getDefaultInstanceProfileArn());
            }
            if (createStackRequest.getDefaultOs() != null) {
                jsonWriter.key("DefaultOs").value(createStackRequest.getDefaultOs());
            }
            if (createStackRequest.getHostnameTheme() != null) {
                jsonWriter.key("HostnameTheme").value(createStackRequest.getHostnameTheme());
            }
            if (createStackRequest.getDefaultAvailabilityZone() != null) {
                jsonWriter.key("DefaultAvailabilityZone").value(createStackRequest.getDefaultAvailabilityZone());
            }
            if (createStackRequest.getDefaultSubnetId() != null) {
                jsonWriter.key("DefaultSubnetId").value(createStackRequest.getDefaultSubnetId());
            }
            if (createStackRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value(createStackRequest.getCustomJson());
            }
            if ((configurationManager = createStackRequest.getConfigurationManager()) != null) {
                jsonWriter.key("ConfigurationManager");
                jsonWriter.object();
                if (configurationManager.getName() != null) {
                    jsonWriter.key("Name").value(configurationManager.getName());
                }
                if (configurationManager.getVersion() != null) {
                    jsonWriter.key("Version").value(configurationManager.getVersion());
                }
                jsonWriter.endObject();
            }
            if (createStackRequest.isUseCustomCookbooks() != null) {
                jsonWriter.key("UseCustomCookbooks").value(createStackRequest.isUseCustomCookbooks());
            }
            if ((customCookbooksSource = createStackRequest.getCustomCookbooksSource()) != null) {
                jsonWriter.key("CustomCookbooksSource");
                jsonWriter.object();
                if (customCookbooksSource.getType() != null) {
                    jsonWriter.key("Type").value(customCookbooksSource.getType());
                }
                if (customCookbooksSource.getUrl() != null) {
                    jsonWriter.key("Url").value(customCookbooksSource.getUrl());
                }
                if (customCookbooksSource.getUsername() != null) {
                    jsonWriter.key("Username").value(customCookbooksSource.getUsername());
                }
                if (customCookbooksSource.getPassword() != null) {
                    jsonWriter.key("Password").value(customCookbooksSource.getPassword());
                }
                if (customCookbooksSource.getSshKey() != null) {
                    jsonWriter.key("SshKey").value(customCookbooksSource.getSshKey());
                }
                if (customCookbooksSource.getRevision() != null) {
                    jsonWriter.key("Revision").value(customCookbooksSource.getRevision());
                }
                jsonWriter.endObject();
            }
            if (createStackRequest.getDefaultSshKeyName() != null) {
                jsonWriter.key("DefaultSshKeyName").value(createStackRequest.getDefaultSshKeyName());
            }
            if (createStackRequest.getDefaultRootDeviceType() != null) {
                jsonWriter.key("DefaultRootDeviceType").value(createStackRequest.getDefaultRootDeviceType());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

