/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.redshift.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    @Override
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        if (createHsmConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHsmConfigurationRequest> request = new DefaultRequest<CreateHsmConfigurationRequest>(createHsmConfigurationRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        if (createHsmConfigurationRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString(createHsmConfigurationRequest.getHsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createHsmConfigurationRequest.getDescription()));
        }
        if (createHsmConfigurationRequest.getHsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringUtils.fromString(createHsmConfigurationRequest.getHsmIpAddress()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringUtils.fromString(createHsmConfigurationRequest.getHsmPartitionName()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringUtils.fromString(createHsmConfigurationRequest.getHsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.getHsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringUtils.fromString(createHsmConfigurationRequest.getHsmServerPublicCertificate()));
        }
        return request;
    }
}

