/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleemail.model.transform;

import com.cloudera.com.amazonaws.services.simpleemail.model.SendDataPoint;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendDataPointStaxUnmarshaller
implements Unmarshaller<SendDataPoint, StaxUnmarshallerContext> {
    private static SendDataPointStaxUnmarshaller instance;

    @Override
    public SendDataPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendDataPoint sendDataPoint = new SendDataPoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sendDataPoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    sendDataPoint.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeliveryAttempts", targetDepth)) {
                    sendDataPoint.setDeliveryAttempts(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bounces", targetDepth)) {
                    sendDataPoint.setBounces(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Complaints", targetDepth)) {
                    sendDataPoint.setComplaints(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Rejects", targetDepth)) continue;
                sendDataPoint.setRejects(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sendDataPoint;
    }

    public static SendDataPointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SendDataPointStaxUnmarshaller();
        }
        return instance;
    }
}

