/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.MethodConverterPair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOWorkflowDefinition
extends WorkflowDefinition {
    private final MethodConverterPair workflowMethod;
    private final Map<String, MethodConverterPair> signals;
    private final MethodConverterPair getStateMethod;
    private final Object workflowImplementationInstance;
    private final DataConverter converter;
    private final DecisionContext context;

    public POJOWorkflowDefinition(Object workflowImplmentationInstance, MethodConverterPair workflowImplementationMethod, Map<String, MethodConverterPair> signals, MethodConverterPair getStateMethod, DataConverter converter, DecisionContext context) throws ClassNotFoundException, SecurityException, NoSuchMethodException, NoSuchFieldException {
        this.workflowImplementationInstance = workflowImplmentationInstance;
        this.workflowMethod = workflowImplementationMethod;
        this.getStateMethod = getStateMethod;
        this.signals = signals;
        this.converter = converter;
        this.context = context;
    }

    @Override
    public Promise<String> execute(final String input) throws WorkflowException {
        final DataConverter c = this.workflowMethod.getConverter() == null ? this.converter : this.workflowMethod.getConverter();
        final Settable<String> result = new Settable<String>();
        final AtomicReference methodResult = new AtomicReference();
        new TryCatchFinally(){

            protected void doTry() throws Throwable {
                Object[] parameters = c.fromData(input, Object[].class);
                Method method = POJOWorkflowDefinition.this.workflowMethod.getMethod();
                Object r = POJOWorkflowDefinition.this.invokeMethod(method, parameters);
                if (!method.getReturnType().equals(Void.TYPE)) {
                    methodResult.set((Promise)r);
                }
            }

            protected void doCatch(Throwable e) throws Throwable {
                if (!(e instanceof CancellationException) || !POJOWorkflowDefinition.this.context.getWorkflowContext().isCancelRequested()) {
                    POJOWorkflowDefinition.this.throwWorkflowException(c, e);
                }
            }

            protected void doFinally() throws Throwable {
                Promise r = (Promise)methodResult.get();
                if (r == null || r.isReady()) {
                    Object workflowResult = r == null ? null : r.get();
                    String convertedResult = c.toData(workflowResult);
                    result.set(convertedResult);
                }
            }
        };
        return result;
    }

    @Override
    public void signalRecieved(String signalName, String details) throws WorkflowException {
        MethodConverterPair signalMethod = this.signals.get(signalName);
        if (signalMethod != null) {
            DataConverter c = signalMethod.getConverter();
            if (c == null) {
                c = this.converter;
            }
            Method method = signalMethod.getMethod();
            Object[] parameters = c.fromData(details, Object[].class);
            try {
                this.invokeMethod(method, parameters);
            }
            catch (Throwable e) {
                this.throwWorkflowException(c, e);
                throw new IllegalStateException("Unreacheable");
            }
        }
    }

    @Override
    public String getWorkflowState() throws WorkflowException {
        if (this.getStateMethod == null) {
            return null;
        }
        DataConverter c = this.getStateMethod.getConverter() == null ? this.converter : this.getStateMethod.getConverter();
        try {
            Method method = this.getStateMethod.getMethod();
            Object result = this.invokeMethod(method, null);
            return c.toData(result);
        }
        catch (Throwable e) {
            this.throwWorkflowException(c, e);
            throw new IllegalStateException("Unreacheable");
        }
    }

    private Object invokeMethod(Method method, Object[] input) throws Throwable {
        try {
            return method.invoke(this.workflowImplementationInstance, input);
        }
        catch (InvocationTargetException invocationException) {
            if (invocationException.getTargetException() != null) {
                throw invocationException.getTargetException();
            }
            throw invocationException;
        }
    }

    private void throwWorkflowException(DataConverter c, Throwable exception) throws WorkflowException {
        if (exception instanceof WorkflowException) {
            throw (WorkflowException)exception;
        }
        String reason = WorkflowExecutionUtils.truncateReason(exception.getMessage());
        String details = null;
        try {
            details = c.toData(exception);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        throw new WorkflowException(reason, details);
    }

    public Object getImplementationInstance() {
        return this.workflowImplementationInstance;
    }
}

