/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.spring;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.interceptors.InvocationSchedule;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class CronInvocationSchedule
implements InvocationSchedule {
    protected static final int SECOND = 1000;
    private final CronSequenceGenerator cronSequenceGenerator;
    private final Date expiration;

    public CronInvocationSchedule(String cronExpression, Date expiration, TimeZone timeZone) {
        this.cronSequenceGenerator = new CronSequenceGenerator(cronExpression, timeZone);
        this.expiration = expiration;
    }

    public long nextInvocationDelaySeconds(Date currentTime, Date startTime, Date lastInvocationTime, int pastInvocatonsCount) {
        Date nextInvocationTime = lastInvocationTime == null ? this.cronSequenceGenerator.next(startTime) : this.cronSequenceGenerator.next(lastInvocationTime);
        long resultMilliseconds = nextInvocationTime.getTime() - currentTime.getTime();
        if (resultMilliseconds < 0L) {
            resultMilliseconds = 0L;
        }
        if (currentTime.getTime() + resultMilliseconds >= this.expiration.getTime()) {
            return -1L;
        }
        return resultMilliseconds / 1000L;
    }
}

