/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.controller;

import java.io.Serializable;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.repository.EESpoonPlugin;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.spoon.ISpoonMenuController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.dom.Document;

public class SpoonMenuABSController
implements ISpoonMenuController,
Serializable {
    private static final long serialVersionUID = -5878581743406400314L;
    protected LogChannelInterface log;
    protected LogLevel logLevel = DefaultLogLevel.getLogLevel();

    public SpoonMenuABSController() {
        this.log = new LogChannel((Object)this);
    }

    public String getName() {
        return "SpoonMenuABSController";
    }

    public void updateMenu(Document doc) {
        try {
            Repository repo;
            Spoon spoon = Spoon.getInstance();
            boolean createPermitted = true;
            boolean executePermitted = true;
            if (spoon != null && spoon.getRepository() != null && spoon.getRepository() instanceof PurRepository && (repo = spoon.getRepository()).hasService(IAbsSecurityProvider.class)) {
                JobGraph jobGraph;
                TransGraph transGraph;
                IAbsSecurityProvider securityProvider = (IAbsSecurityProvider)repo.getService(IAbsSecurityProvider.class);
                createPermitted = securityProvider.isAllowed("org.pentaho.repository.create");
                executePermitted = securityProvider.isAllowed("org.pentaho.repository.execute");
                EngineMetaInterface meta = spoon.getActiveMeta();
                if (meta != null && (meta instanceof JobMeta || meta instanceof TransMeta)) {
                    ((XulToolbarbutton)doc.getElementById("toolbar-file-new")).setDisabled(!createPermitted);
                    ((XulToolbarbutton)doc.getElementById("toolbar-file-save")).setDisabled(!createPermitted);
                    ((XulToolbarbutton)doc.getElementById("toolbar-file-save-as")).setDisabled(!createPermitted);
                    ((XulMenuitem)doc.getElementById("trans-class-new")).setDisabled(!createPermitted);
                    ((XulMenuitem)doc.getElementById("job-class-new")).setDisabled(!createPermitted);
                    ((XulMenu)doc.getElementById("file-new")).setDisabled(!createPermitted);
                    ((XulMenuitem)doc.getElementById("file-save")).setDisabled(!createPermitted);
                    ((XulMenuitem)doc.getElementById("file-save-as")).setDisabled(!createPermitted);
                    ((XulMenuitem)doc.getElementById("file-close")).setDisabled(!createPermitted);
                }
                ((XulMenuitem)doc.getElementById("process-run")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-preview")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-debug")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-replay")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-verify")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-impact")).setDisabled(!executePermitted);
                ((XulMenuitem)doc.getElementById("trans-get-sql")).setDisabled(!executePermitted);
                ((XulMenu)doc.getElementById("trans-last")).setDisabled(!executePermitted);
                boolean exportAllowed = createPermitted && executePermitted;
                ((XulMenu)doc.getElementById("file-export")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("repository-export-all")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("file-save-as-vfs")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("edit-cut-steps")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("edit-copy-steps")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("edit.copy-file")).setDisabled(!exportAllowed);
                ((XulMenuitem)doc.getElementById("edit-paste-steps")).setDisabled(!exportAllowed);
                if (doc.getElementById("trans-schedule") != null) {
                    ((XulMenuitem)doc.getElementById("trans-schedule")).setDisabled(!executePermitted);
                }
                if ((transGraph = Spoon.getInstance().getActiveTransGraph()) != null) {
                    XulToolbar toolbar = transGraph.getToolbar();
                    XulToolbarbutton runButton = (XulToolbarbutton)toolbar.getElementById("trans-run");
                    XulToolbarbutton debugButton = (XulToolbarbutton)toolbar.getElementById("trans-debug");
                    XulToolbarbutton previewButton = (XulToolbarbutton)toolbar.getElementById("trans-preview");
                    XulToolbarbutton replayButton = (XulToolbarbutton)toolbar.getElementById("trans-replay");
                    XulToolbarbutton verifyButton = (XulToolbarbutton)toolbar.getElementById("trans-verify");
                    XulToolbarbutton impactButton = (XulToolbarbutton)toolbar.getElementById("trans-impact");
                    XulToolbarbutton generateSqlButton = (XulToolbarbutton)toolbar.getElementById("trans-get-sql");
                    if (runButton != null && runButton.isDisabled() ^ !executePermitted) {
                        runButton.setDisabled(!executePermitted);
                    }
                    if (debugButton != null && debugButton.isDisabled() ^ !executePermitted) {
                        debugButton.setDisabled(!executePermitted);
                    }
                    if (previewButton != null && previewButton.isDisabled() ^ !executePermitted) {
                        previewButton.setDisabled(!executePermitted);
                    }
                    if (replayButton != null && replayButton.isDisabled() ^ !executePermitted) {
                        replayButton.setDisabled(!executePermitted);
                    }
                    if (verifyButton != null && verifyButton.isDisabled() ^ !executePermitted) {
                        verifyButton.setDisabled(!executePermitted);
                    }
                    if (impactButton != null && impactButton.isDisabled() ^ !executePermitted) {
                        impactButton.setDisabled(!executePermitted);
                    }
                    if (generateSqlButton != null && generateSqlButton.isDisabled() ^ !executePermitted) {
                        generateSqlButton.setDisabled(!executePermitted);
                    }
                }
                if ((jobGraph = Spoon.getInstance().getActiveJobGraph()) != null) {
                    XulToolbar toolbar = jobGraph.getToolbar();
                    XulToolbarbutton runButton = (XulToolbarbutton)toolbar.getElementById("job-run");
                    XulToolbarbutton generateSqlButton = (XulToolbarbutton)toolbar.getElementById("job-get-sql");
                    if (runButton != null && runButton.isDisabled() ^ !executePermitted) {
                        runButton.setDisabled(!executePermitted);
                    }
                    if (generateSqlButton != null && generateSqlButton.isDisabled() ^ !executePermitted) {
                        generateSqlButton.setDisabled(!executePermitted);
                    }
                }
            }
            EESpoonPlugin.updateChangedWarningDialog(createPermitted);
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
        }
    }
}

