/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.ILockObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.BrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjects;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class RepositoryLockController
extends AbstractXulEventHandler
implements IUISupportController,
Serializable {
    private static final long serialVersionUID = -1770253263177354811L;
    private static final Class<?> PKG = IUIEEUser.class;
    private BrowseController browseController = null;
    private BindingFactory bindingFactory = null;
    private XulMessageBox messageBox;
    private ILockService service = null;
    private Repository repository = null;
    private XulMenuitem lockFileMenuItem;
    private XulMenuitem deleteFileMenuItem;
    private XulMenuitem renameFileMenuItem;
    private XulTree fileTable;
    private XulTree folderTree;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };
    private BindingConvertor<List<UIRepositoryObject>, Boolean> checkLockPermissions = new BindingConvertor<List<UIRepositoryObject>, Boolean>(){

        public Boolean sourceToTarget(List<UIRepositoryObject> selectedRepoObjects) {
            boolean result = false;
            try {
                if (selectedRepoObjects.size() == 1 && selectedRepoObjects.get(0) instanceof UIRepositoryDirectory) {
                    return true;
                }
                if (selectedRepoObjects.size() == 1 && selectedRepoObjects.get(0) instanceof ILockObject) {
                    UIRepositoryContent contentToLock = (UIRepositoryContent)selectedRepoObjects.get(0);
                    result = ((ILockObject)contentToLock).isLocked() ? (RepositoryLockController.this.repository instanceof PurRepository ? RepositoryLockController.this.service.canUnlockFileById(contentToLock.getObjectId()) : ((ILockObject)contentToLock).getRepositoryLock().getLogin().equalsIgnoreCase(RepositoryLockController.this.repository.getUserInfo().getLogin())) : true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public List<UIRepositoryObject> targetToSource(Boolean arg0) {
            return null;
        }
    };
    private BindingConvertor<List<UIRepositoryObject>, Boolean> forButtons = new BindingConvertor<List<UIRepositoryObject>, Boolean>(){

        public Boolean sourceToTarget(List<UIRepositoryObject> value) {
            return value != null && value.size() == 1;
        }

        public List<UIRepositoryObject> targetToSource(Boolean value) {
            return null;
        }
    };
    private BindingConvertor<List<UIRepositoryObject>, Boolean> checkLockedStateBool = new BindingConvertor<List<UIRepositoryObject>, Boolean>(){

        public Boolean sourceToTarget(List<UIRepositoryObject> value) {
            boolean result = false;
            try {
                if (value != null && value.size() == 1 && value.get(0) != null && value.get(0) instanceof ILockObject) {
                    result = ((ILockObject)value.get(0)).isLocked();
                }
            }
            catch (KettleException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public List<UIRepositoryObject> targetToSource(Boolean value) {
            return null;
        }
    };
    private BindingConvertor<List<UIRepositoryObject>, Boolean> checkLockedState = new BindingConvertor<List<UIRepositoryObject>, Boolean>(){

        public Boolean sourceToTarget(List<UIRepositoryObject> value) {
            boolean result = false;
            try {
                if (value != null && value.size() == 1 && value.get(0) != null && value.get(0) instanceof ILockObject) {
                    result = ((ILockObject)value.get(0)).isLocked();
                }
            }
            catch (KettleException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public List<UIRepositoryObject> targetToSource(Boolean value) {
            return null;
        }
    };

    public void init(Repository rep) throws ControllerInitializationException {
        try {
            if (rep == null || !rep.hasService(ILockService.class)) {
                throw new ControllerInitializationException(BaseMessages.getString(PKG, (String)"RepositoryLockController.ERROR_0001_UNABLE_TO_INITIAL_REPOSITORY_SERVICE", ILockService.class, (String[])new String[0]));
            }
            this.repository = rep;
            this.service = (ILockService)rep.getService(ILockService.class);
            this.bindingFactory = new DefaultBindingFactory();
            this.bindingFactory.setDocument(this.getXulDomContainer().getDocumentRoot());
            XulEventHandler eventHandler = this.getXulDomContainer().getEventHandler("browseController");
            if (eventHandler instanceof BrowseController) {
                this.browseController = (BrowseController)eventHandler;
            }
            this.fileTable = (XulTree)this.getXulDomContainer().getDocumentRoot().getElementById("file-table");
            this.folderTree = (XulTree)this.document.getElementById("folder-tree");
            this.lockFileMenuItem = (XulMenuitem)this.getXulDomContainer().getDocumentRoot().getElementById("file-context-lock");
            this.deleteFileMenuItem = (XulMenuitem)this.getXulDomContainer().getDocumentRoot().getElementById("file-context-delete");
            this.renameFileMenuItem = (XulMenuitem)this.getXulDomContainer().getDocumentRoot().getElementById("file-context-rename");
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
            this.createBindings();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onDragFromGlobalTree(DropEvent event) {
        Collection selectedItems = this.folderTree.getSelectedItems();
        if (selectedItems.size() > 0) {
            for (Object object : selectedItems) {
                if (!(object instanceof UIRepositoryDirectory)) continue;
                try {
                    if (this.repositoryDirectoryHasLockedObject(event, (UIRepositoryDirectory)object)) continue;
                    this.browseController.onDragFromGlobalTree(event);
                }
                catch (KettleException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean repositoryDirectoryHasLockedObject(DropEvent event, UIRepositoryDirectory dir) throws KettleException {
        if (this.areAnyRepositoryObjectsLocked(event, dir.getRepositoryObjects())) {
            return true;
        }
        for (UIRepositoryObject ro : dir.getChildren()) {
            if (!(ro instanceof UIRepositoryDirectory)) continue;
            UIRepositoryDirectory directory = (UIRepositoryDirectory)ro;
            this.repositoryDirectoryHasLockedObject(event, directory);
        }
        return false;
    }

    private boolean areAnyRepositoryObjectsLocked(DropEvent event, UIRepositoryObjects repositoryObjects) throws KettleException {
        for (UIRepositoryObject ro : repositoryObjects) {
            UIRepositoryContent contentToLock;
            if (!(ro instanceof ILockObject) || !((ILockObject)(contentToLock = (UIRepositoryContent)ro)).isLocked()) continue;
            event.setAccepted(false);
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.FolderMoveNotAllowed", (String[])new String[0]));
            this.messageBox.open();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDragFromLocalTable(DropEvent event) {
        try {
            block6: {
                Collection selectedRepoObjects = this.fileTable.getSelectedItems();
                if (selectedRepoObjects.size() <= 0) return;
                Iterator i$ = selectedRepoObjects.iterator();
                while (i$.hasNext()) {
                    Object ro = i$.next();
                    if (ro instanceof UIRepositoryObject && ro instanceof ILockObject) {
                        UIRepositoryContent contentToLock = (UIRepositoryContent)ro;
                        if (((ILockObject)contentToLock).isLocked()) {
                            event.setAccepted(false);
                            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.MoveNotAllowed", (String[])new String[0]));
                            this.messageBox.open();
                            return;
                        }
                        this.browseController.onDragFromLocalTable(event);
                        continue;
                    }
                    if (!(ro instanceof UIRepositoryDirectory) || !this.repositoryDirectoryHasLockedObject(event, (UIRepositoryDirectory)ro)) {
                        continue;
                    }
                    break block6;
                }
                return;
            }
            event.setAccepted(false);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "repositoryLockController";
    }

    protected void createBindings() {
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "lock-menu", "!disabled", new BindingConvertor[]{this.forButtons});
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "file-context-lock", "selected", new BindingConvertor[]{this.checkLockedState});
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", (Object)this, "menuItemEnabledState", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "file-context-locknotes", "!disabled", new BindingConvertor[]{this.checkLockedStateBool});
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "lock-context-lock", "selected", new BindingConvertor[]{this.checkLockedState});
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "lock-context-lock", "!disabled", new BindingConvertor[]{this.checkLockPermissions});
        this.bindingFactory.createBinding((Object)this.browseController, "repositoryObjects", "lock-context-locknotes", "!disabled", new BindingConvertor[]{this.checkLockedStateBool});
    }

    public void lockContent() throws Exception {
        List selectedRepoObjects = this.browseController.getSelectedFileItems();
        if (selectedRepoObjects.size() > 0 && selectedRepoObjects.get(0) instanceof UIRepositoryContent) {
            final UIRepositoryContent contentToLock = (UIRepositoryContent)selectedRepoObjects.get(0);
            if (((ILockObject)contentToLock).isLocked()) {
                ((ILockObject)contentToLock).unlock();
                this.browseController.getSelectedItemsBinding().fireSourceChanged();
            } else {
                XulPromptBox lockNotePrompt = this.promptLockMessage(this.document, this.messages, null);
                lockNotePrompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

                    public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                        if (!status.equals((Object)XulDialogCallback.Status.CANCEL)) {
                            try {
                                ((ILockObject)contentToLock).lock(value);
                                RepositoryLockController.this.browseController.getSelectedItemsBinding().fireSourceChanged();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            XulMenuitem lockMenuItem = (XulMenuitem)RepositoryLockController.this.document.getElementById("lock-context-lock");
                            lockMenuItem.setSelected(false);
                            lockMenuItem = (XulMenuitem)RepositoryLockController.this.document.getElementById("file-context-lock");
                            lockMenuItem.setSelected(false);
                        }
                    }

                    public void onError(XulComponent component, Throwable err) {
                        throw new RuntimeException(err);
                    }
                });
                lockNotePrompt.open();
            }
        }
    }

    public void viewLockNote() throws Exception {
        List selectedRepoObjects = this.browseController.getSelectedFileItems();
        if (selectedRepoObjects.size() > 0 && selectedRepoObjects.get(0) instanceof UIRepositoryContent) {
            UIRepositoryContent contentToLock = (UIRepositoryContent)selectedRepoObjects.get(0);
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setTitle(BaseMessages.getString(PKG, (String)"PurRepository.LockNote.Title", (String[])new String[0]));
            msgBox.setMessage(((ILockObject)contentToLock).getLockMessage());
            msgBox.open();
        }
    }

    private XulPromptBox promptLockMessage(Document document, ResourceBundle messages, String defaultMessage) throws XulException {
        XulPromptBox prompt = (XulPromptBox)document.createElement("promptbox");
        prompt.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorer.LockMessage.Title", (String[])new String[0]));
        prompt.setButtons((Object[])new DialogConstant[]{DialogConstant.OK, DialogConstant.CANCEL});
        prompt.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorer.LockMessage.Label", (String[])new String[0]));
        prompt.setValue(defaultMessage == null ? BaseMessages.getString(PKG, (String)"RepositoryExplorer.DefaultLockMessage", (String[])new String[0]) : defaultMessage);
        return prompt;
    }

    public void setMenuItemEnabledState(List<UIRepositoryObject> selectedRepoObjects) {
        try {
            boolean result = false;
            if (selectedRepoObjects.size() == 1 && selectedRepoObjects.get(0) instanceof UIRepositoryDirectory) {
                this.lockFileMenuItem.setDisabled(true);
                this.deleteFileMenuItem.setDisabled(false);
                this.renameFileMenuItem.setDisabled(false);
            } else if (selectedRepoObjects.size() == 1 && selectedRepoObjects.get(0) instanceof ILockObject) {
                UIRepositoryContent contentToLock = (UIRepositoryContent)selectedRepoObjects.get(0);
                if (((ILockObject)contentToLock).isLocked()) {
                    result = this.repository instanceof PurRepository ? this.service.canUnlockFileById(contentToLock.getObjectId()) : ((ILockObject)contentToLock).getRepositoryLock().getLogin().equalsIgnoreCase(this.repository.getUserInfo().getLogin());
                    this.lockFileMenuItem.setDisabled(!result);
                    this.deleteFileMenuItem.setDisabled(!result);
                    this.renameFileMenuItem.setDisabled(!result);
                } else {
                    this.lockFileMenuItem.setDisabled(false);
                    this.deleteFileMenuItem.setDisabled(false);
                    this.renameFileMenuItem.setDisabled(false);
                }
            } else {
                this.lockFileMenuItem.setDisabled(true);
                this.deleteFileMenuItem.setDisabled(true);
                this.renameFileMenuItem.setDisabled(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

