/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurity;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.util.AbstractModelList;

public class UISecurityRole
extends XulEventSourceAdapter
implements Serializable {
    private static final long serialVersionUID = -2525642001107996480L;
    private UISecurity.Mode mode;
    private List<IUIUser> availableUsers;
    private AbstractModelList<IUIUser> assignedUsers;
    private List<IUIUser> availableSelectedUsers = new ArrayList<IUIUser>();
    private List<IUIUser> assignedSelectedUsers = new ArrayList<IUIUser>();
    private boolean userAssignmentPossible;
    private boolean userUnassignmentPossible;
    private String name;
    private String description;

    public UISecurityRole() {
        this.availableUsers = new ArrayList<IUIUser>();
        this.assignedUsers = new AbstractModelList();
        this.assignedUsers.addPropertyChangeListener("children", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List previousValue = UISecurityRole.this.getPreviousSelectedUsers();
                UISecurityRole.this.firePropertyChange("selectedUsers", previousValue, UISecurityRole.this.assignedUsers);
            }
        });
        this.description = null;
        this.name = null;
    }

    public List<IUIUser> getAvailableSelectedUsers() {
        return this.availableSelectedUsers;
    }

    public void setAvailableSelectedUsers(List<Object> availableSelectedUsers) {
        ArrayList<IUIUser> previousVal = new ArrayList<IUIUser>();
        previousVal.addAll(this.availableSelectedUsers);
        this.availableSelectedUsers.clear();
        if (availableSelectedUsers != null && availableSelectedUsers.size() > 0) {
            for (Object user : availableSelectedUsers) {
                this.availableSelectedUsers.add((IUIUser)user);
            }
        }
        this.firePropertyChange("availableSelectedUsers", previousVal, this.availableSelectedUsers);
        this.fireUserAssignmentPropertyChange();
    }

    public List<IUIUser> getAssignedSelectedUsers() {
        return this.assignedSelectedUsers;
    }

    public void setAssignedSelectedUsers(List<Object> assignedSelectedUsers) {
        ArrayList<IUIUser> previousVal = new ArrayList<IUIUser>();
        previousVal.addAll(this.assignedSelectedUsers);
        this.assignedSelectedUsers.clear();
        if (assignedSelectedUsers != null && assignedSelectedUsers.size() > 0) {
            for (Object user : assignedSelectedUsers) {
                this.assignedSelectedUsers.add((IUIUser)user);
            }
        }
        this.firePropertyChange("assignedSelectedUsers", previousVal, this.assignedSelectedUsers);
        this.fireUserUnassignmentPropertyChange();
    }

    public UISecurityRole getUISecurityRole() {
        return this;
    }

    public void setRole(IUIRole role, List<IUIUser> users) {
        this.setAvailableUsers(users);
        this.setDescription(role.getDescription());
        this.setName(role.getName());
        for (IUIUser user : role.getUsers()) {
            this.removeFromAvailableUsers(user.getName());
            this.addToAssignedUsers(user);
        }
    }

    public UISecurity.Mode getMode() {
        return this.mode;
    }

    public void setMode(UISecurity.Mode mode) {
        this.mode = mode;
        this.firePropertyChange("mode", null, mode);
    }

    public List<IUIUser> getAvailableUsers() {
        return this.availableUsers;
    }

    public void setAvailableUsers(List<IUIUser> availableUsers) {
        List<IUIUser> previousValue = this.getPreviousAvailableUsers();
        this.availableUsers.clear();
        if (availableUsers != null) {
            this.availableUsers.addAll(availableUsers);
        }
        this.firePropertyChange("availableUsers", previousValue, this.availableUsers);
    }

    public List<IUIUser> getAssignedUsers() {
        return this.assignedUsers;
    }

    public void setAssignedUsers(AbstractModelList<IUIUser> selectedUsers) {
        List<IUIUser> previousValue = this.getPreviousSelectedUsers();
        this.assignedUsers.clear();
        if (selectedUsers != null) {
            this.assignedUsers.addAll(selectedUsers);
        }
        this.firePropertyChange("assignedUsers", previousValue, this.assignedUsers);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String previousVal = this.name;
        this.name = name;
        this.firePropertyChange("name", previousVal, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String previousVal = this.description;
        this.description = description;
        this.firePropertyChange("description", previousVal, description);
    }

    public void clear() {
        this.setMode(UISecurity.Mode.ADD);
        this.setName("");
        this.setDescription("");
        this.setAvailableUsers(null);
        this.setAssignedSelectedUsers(null);
        this.setAvailableSelectedUsers(null);
        this.setAssignedUsers(null);
        this.setUserAssignmentPossible(false);
        this.setUserUnassignmentPossible(false);
    }

    public void assignUsers(List<Object> usersToAssign) {
        for (Object userToAssign : usersToAssign) {
            this.assignUser((IUIUser)userToAssign);
        }
        this.setAssignedSelectedUsers(usersToAssign);
        this.setAvailableSelectedUsers(new ArrayList<Object>());
        this.firePropertyChange("userAssignmentPossible", null, false);
    }

    public void assignUser(IUIUser userToAssign) {
        this.addToAssignedUsers(userToAssign);
        this.removeFromAvailableUsers(userToAssign.getName());
    }

    public void unassignUsers(List<Object> usersToUnAssign) {
        for (Object userToUnAssign : usersToUnAssign) {
            this.unassignUser((IUIUser)userToUnAssign);
        }
        this.setAvailableSelectedUsers(usersToUnAssign);
        this.setAssignedSelectedUsers(new ArrayList<Object>());
        this.firePropertyChange("userUnassignmentPossible", null, false);
    }

    public void unassignUser(IUIUser userToUnAssign) {
        this.removeFromAssignedUsers(userToUnAssign.getName());
        this.addToAvailableUsers(userToUnAssign);
    }

    public boolean isUserAssignmentPossible() {
        return this.userAssignmentPossible;
    }

    public void setUserAssignmentPossible(boolean userAssignmentPossible) {
        this.userAssignmentPossible = userAssignmentPossible;
        this.fireUserAssignmentPropertyChange();
    }

    public boolean isUserUnassignmentPossible() {
        return this.userUnassignmentPossible;
    }

    public void setUserUnassignmentPossible(boolean userUnassignmentPossible) {
        this.userUnassignmentPossible = userUnassignmentPossible;
        this.fireUserUnassignmentPropertyChange();
    }

    public IRole getRole(IRoleSupportSecurityManager rsm) {
        IRole roleInfo = null;
        try {
            roleInfo = rsm.constructRole();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        roleInfo.setDescription(this.description);
        roleInfo.setName(this.name);
        for (IUIUser user : this.getAssignedUsers()) {
            roleInfo.addUser(user.getUserInfo());
        }
        return roleInfo;
    }

    private void addToAssignedUsers(IUIUser userToAdd) {
        List<IUIUser> previousValue = this.getPreviousSelectedUsers();
        this.assignedUsers.add((Object)userToAdd);
        if (this.assignedUsers.size() == 1) {
            this.setUserUnassignmentPossible(true);
        }
        this.firePropertyChange("assignedUsers", previousValue, this.assignedUsers);
    }

    private void addToAvailableUsers(IUIUser userToAdd) {
        List<IUIUser> previousValue = this.getPreviousAvailableUsers();
        this.availableUsers.add(userToAdd);
        if (this.availableUsers.size() == 1) {
            this.setUserAssignmentPossible(true);
        }
        this.firePropertyChange("availableUsers", previousValue, this.availableUsers);
    }

    private void removeFromAvailableUsers(String userName) {
        List<IUIUser> previousValue = this.getPreviousAvailableUsers();
        this.availableUsers.remove(this.getAvailableUser(userName));
        if (this.availableUsers.size() == 0) {
            this.setUserAssignmentPossible(false);
        }
        this.firePropertyChange("availableUsers", previousValue, this.availableUsers);
        this.fireUserAssignmentPropertyChange();
    }

    private void removeFromAssignedUsers(String userName) {
        List<IUIUser> previousValue = this.getPreviousSelectedUsers();
        this.assignedUsers.remove((Object)this.getSelectedUser(userName));
        if (this.assignedUsers.size() == 0) {
            this.setUserUnassignmentPossible(false);
        }
        this.firePropertyChange("assignedUsers", previousValue, this.assignedUsers);
        this.fireUserUnassignmentPropertyChange();
    }

    private IUIUser getSelectedUser(String userName) {
        for (IUIUser user : this.assignedUsers) {
            if (!user.getName().equals(userName)) continue;
            return user;
        }
        return null;
    }

    private void fireUserUnassignmentPropertyChange() {
        if (this.userUnassignmentPossible && this.assignedUsers.size() > 0 && this.assignedSelectedUsers.size() > 0) {
            this.firePropertyChange("userUnassignmentPossible", null, true);
        } else {
            this.firePropertyChange("userUnassignmentPossible", null, false);
        }
    }

    private void fireUserAssignmentPropertyChange() {
        if (this.userAssignmentPossible && this.availableUsers.size() > 0 && this.availableSelectedUsers.size() > 0) {
            this.firePropertyChange("userAssignmentPossible", null, true);
        } else {
            this.firePropertyChange("userAssignmentPossible", null, false);
        }
    }

    private IUIUser getAvailableUser(String userName) {
        for (IUIUser user : this.availableUsers) {
            if (!user.getName().equals(userName)) continue;
            return user;
        }
        return null;
    }

    private List<IUIUser> getPreviousAvailableUsers() {
        ArrayList<IUIUser> previousValue = new ArrayList<IUIUser>();
        for (IUIUser ru : this.availableUsers) {
            previousValue.add(ru);
        }
        return previousValue;
    }

    private List<IUIUser> getPreviousSelectedUsers() {
        ArrayList<IUIUser> previousValue = new ArrayList<IUIUser>();
        for (IUIUser ru : this.assignedUsers) {
            previousValue.add(ru);
        }
        return previousValue;
    }
}

