/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleJobGetJPAExecutor
implements JPAExecutor<BundleJobBean> {
    private String bundleJobId = null;

    public BundleJobGetJPAExecutor(String bundleJobId) {
        ParamChecker.notNull(bundleJobId, "bundleJobId");
        this.bundleJobId = bundleJobId;
    }

    @Override
    public String getName() {
        return "BundleJobGetJPAExecutor";
    }

    @Override
    public BundleJobBean execute(EntityManager em) throws JPAExecutorException {
        List bdBeans;
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_JOB");
            q.setParameter("id", (Object)this.bundleJobId);
            bdBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        BundleJobBean bean = null;
        if (bdBeans != null && bdBeans.size() > 0) {
            bean = (BundleJobBean)bdBeans.get(0);
            bean.setStatus(bean.getStatus());
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0604, this.bundleJobId);
    }
}

