/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.servlet.BaseJobServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.GraphGenerator;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class V1JobServlet
extends BaseJobServlet {
    private static final String INSTRUMENTATION_NAME = "v1job";
    public static final String COORD_ACTIONS_DEFAULT_LENGTH = "oozie.coord.actions.default.length";

    public V1JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    protected V1JobServlet(String instrumentation_name) {
        super(instrumentation_name);
    }

    @Override
    protected void startJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.startWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.startBundleJob(request, response);
        } else {
            throw new XServletException(400, ErrorCode.E0303, "action", "start");
        }
    }

    @Override
    protected void resumeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.resumeWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.resumeBundleJob(request, response);
        } else {
            this.resumeCoordinatorJob(request, response);
        }
    }

    @Override
    protected void suspendJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.suspendWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.suspendBundleJob(request, response);
        } else {
            this.suspendCoordinatorJob(request, response);
        }
    }

    @Override
    protected JSONObject killJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        JSONObject json = null;
        if (jobId.endsWith("-W")) {
            this.killWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.killBundleJob(request, response);
        } else {
            json = this.killCoordinator(request, response);
        }
        return json;
    }

    @Override
    protected void changeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-B")) {
            this.changeBundleJob(request, response);
        } else {
            this.changeCoordinatorJob(request, response);
        }
    }

    @Override
    protected JSONObject ignoreJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v1");
    }

    @Override
    protected JSONObject reRunJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        JSONObject json = null;
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.reRunWorkflowJob(request, response, conf);
        } else if (jobId.endsWith("-B")) {
            this.rerunBundleJob(request, response, conf);
        } else {
            json = this.reRunCoordinatorActions(request, response, conf);
        }
        return json;
    }

    @Override
    protected JsonBean getJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException, BaseEngineException {
        ServletInputStream is = request.getInputStream();
        byte[] b = new byte[101];
        while (is.readLine(b, 0, 100) != -1) {
            XLog.getLog(((Object)((Object)this)).getClass()).warn("Printing :" + new String(b));
        }
        JsonBean jobBean = null;
        String jobId = this.getResourceName(request);
        jobBean = jobId.endsWith("-B") ? this.getBundleJob(request, response) : (jobId.endsWith("-W") ? this.getWorkflowJob(request, response) : (jobId.contains("-W@") ? this.getWorkflowAction(request, response) : (jobId.contains("-C@") ? this.getCoordinatorAction(request, response) : this.getCoordinatorJob(request, response))));
        return jobBean;
    }

    @Override
    protected String getJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobDefinition = null;
        String jobId = this.getResourceName(request);
        jobDefinition = jobId.endsWith("-W") ? this.getWorkflowJobDefinition(request, response) : (jobId.endsWith("-B") ? this.getBundleJobDefinition(request, response) : this.getCoordinatorJobDefinition(request, response));
        return jobDefinition;
    }

    @Override
    protected void streamJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        try {
            String jobId = this.getResourceName(request);
            if (jobId.endsWith("-W")) {
                this.streamWorkflowJobLog(request, response);
            } else if (jobId.endsWith("-B")) {
                this.streamBundleJobLog(request, response);
            } else {
                this.streamCoordinatorJobLog(request, response);
            }
        }
        catch (Exception e) {
            throw new XServletException(400, ErrorCode.E0307, e.getMessage());
        }
    }

    @Override
    protected void streamJobGraph(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            try {
                response.setContentType("image/png");
                String showKill = request.getParameter("show-kill");
                boolean sK = showKill != null && (showKill.equalsIgnoreCase("yes") || showKill.equals("1") || showKill.equalsIgnoreCase("true"));
                new GraphGenerator(this.getWorkflowJobDefinition(request, response), (WorkflowJobBean)this.getWorkflowJob(request, response), sK).write((OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                throw new XServletException(404, ErrorCode.E0307, e.getMessage(), e);
            }
        } else {
            throw new XServletException(400, ErrorCode.E0306, new Object[0]);
        }
    }

    private void startWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.start(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void startBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.start(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.resume(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.resume(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String jobId = this.getResourceName(request);
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        try {
            coordEngine.resume(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.suspend(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.suspend(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            coordEngine.suspend(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void killWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.kill(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private JSONObject killCoordinator(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String jobId = this.getResourceName(request);
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        JSONObject json = null;
        String rangeType = request.getParameter("type");
        String scope = request.getParameter("scope");
        try {
            if (rangeType != null && scope != null) {
                XLog.getLog(((Object)((Object)this)).getClass()).info("Kill coordinator actions for jobId=" + jobId + ", rangeType=" + rangeType + ",scope=" + scope);
                json = new JSONObject();
                CoordinatorActionInfo coordInfo = coordEngine.killActions(jobId, rangeType, scope);
                List<CoordinatorActionBean> coordActions = coordInfo != null ? coordInfo.getCoordActions() : CoordUtils.getCoordActions(rangeType, jobId, scope, true);
                json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(coordActions, "GMT"));
            } else {
                coordEngine.kill(jobId);
            }
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private void killBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.kill(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void changeCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String changeValue = request.getParameter("value");
        try {
            coordEngine.change(jobId, changeValue);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void changeBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String changeValue = request.getParameter("value");
        try {
            bundleEngine.change(jobId, changeValue);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void reRunWorkflowJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.reRun(jobId, conf);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void rerunBundleJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String coordScope = request.getParameter("coord-scope");
        String dateScope = request.getParameter("date-scope");
        String refresh = request.getParameter("refresh");
        String noCleanup = request.getParameter("nocleanup");
        XLog.getLog(((Object)((Object)this)).getClass()).info("Rerun Bundle for jobId=" + jobId + ", coordScope=" + coordScope + ", dateScope=" + dateScope + ", refresh=" + refresh + ", noCleanup=" + noCleanup);
        try {
            bundleEngine.reRun(jobId, coordScope, dateScope, Boolean.valueOf(refresh), Boolean.valueOf(noCleanup));
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private JSONObject reRunCoordinatorActions(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String rerunType = request.getParameter("type");
        String scope = request.getParameter("scope");
        String refresh = request.getParameter("refresh");
        String noCleanup = request.getParameter("nocleanup");
        XLog.getLog(((Object)((Object)this)).getClass()).info("Rerun coordinator for jobId=" + jobId + ", rerunType=" + rerunType + ",scope=" + scope + ",refresh=" + refresh + ", noCleanup=" + noCleanup);
        try {
            if (!rerunType.equals("date") && !rerunType.equals("action")) {
                throw new CommandException(ErrorCode.E1018, "date or action expected.");
            }
            CoordinatorActionInfo coordInfo = coordEngine.reRun(jobId, rerunType, scope, Boolean.valueOf(refresh), Boolean.valueOf(noCleanup));
            List<CoordinatorActionBean> coordActions = coordInfo != null ? coordInfo.getCoordActions() : CoordUtils.getCoordActions(rerunType, jobId, scope, false);
            json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(coordActions, "GMT"));
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    protected JsonBean getWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = this.getWorkflowJobBean(request, response);
        this.swapMRActionID((WorkflowJob)jobBean);
        return jobBean;
    }

    protected JsonBean getWorkflowJobBean(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = null;
        String jobId = this.getResourceName(request);
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        int start = startStr != null ? Integer.parseInt(startStr) : 1;
        start = start < 1 ? 1 : start;
        int len = lenStr != null ? Integer.parseInt(lenStr) : 0;
        len = len < 1 ? Integer.MAX_VALUE : len;
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        try {
            jobBean = (JsonBean)dagEngine.getJob(jobId, start, len);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return jobBean;
    }

    private void swapMRActionID(WorkflowJob wjBean) {
        List actions = wjBean.getActions();
        if (actions != null) {
            for (WorkflowAction wa : actions) {
                this.swapMRActionID(wa);
            }
        }
    }

    private void swapMRActionID(WorkflowAction waBean) {
        String childId;
        if (waBean.getType().equals("map-reduce") && (childId = waBean.getExternalChildIDs()) != null && !childId.equals("")) {
            String consoleBase = this.getConsoleBase(waBean.getConsoleUrl());
            ((WorkflowActionBean)waBean).setConsoleUrl(consoleBase + childId);
            ((WorkflowActionBean)waBean).setExternalId(childId);
            ((WorkflowActionBean)waBean).setExternalChildIDs("");
        }
    }

    private String getConsoleBase(String url) {
        String consoleBase = null;
        consoleBase = url.indexOf("application") != -1 ? url.split("application_[0-9]+_[0-9]+")[0] : url.split("job_[0-9]+_[0-9]+")[0];
        return consoleBase;
    }

    protected JsonBean getWorkflowAction(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean actionBean = this.getWorkflowActionBean(request, response);
        this.swapMRActionID((WorkflowAction)actionBean);
        return actionBean;
    }

    protected JsonBean getWorkflowActionBean(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        WorkflowActionBean actionBean = null;
        String actionId = this.getResourceName(request);
        try {
            actionBean = dagEngine.getWorkflowAction(actionId);
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return actionBean;
    }

    protected JsonBean getCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        CoordinatorJobBean jobBean = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        String filter = request.getParameter("filter");
        String orderStr = request.getParameter("order");
        boolean order = orderStr != null && orderStr.equals("desc");
        int offset = startStr != null ? Integer.parseInt(startStr) : 1;
        offset = offset < 1 ? 1 : offset;
        int defaultLen = Services.get().getConf().getInt(COORD_ACTIONS_DEFAULT_LENGTH, 1000);
        int len = lenStr != null ? Integer.parseInt(lenStr) : 0;
        len = this.getCoordinatorJobLength(defaultLen, len);
        try {
            CoordinatorJobBean coordJob;
            jobBean = coordJob = coordEngine.getCoordJob(jobId, filter, offset, len, order);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return jobBean;
    }

    protected int getCoordinatorJobLength(int defaultLen, int len) {
        return len < 1 ? defaultLen : len;
    }

    private JsonBean getBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        BundleJobBean jobBean = null;
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            jobBean = bundleEngine.getBundleJob(jobId);
            return jobBean;
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private JsonBean getCoordinatorAction(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        CoordinatorActionBean actionBean = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String actionId = this.getResourceName(request);
        try {
            actionBean = coordEngine.getCoordAction(actionId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return actionBean;
    }

    private String getWorkflowJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String wfDefinition;
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            wfDefinition = dagEngine.getDefinition(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return wfDefinition;
    }

    private String getBundleJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String bundleDefinition;
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleDefinition = bundleEngine.getDefinition(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return bundleDefinition;
    }

    private String getCoordinatorJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String coordDefinition = null;
        try {
            coordDefinition = coordEngine.getDefinition(jobId);
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return coordDefinition;
    }

    private void streamWorkflowJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.streamLog(jobId, response.getWriter(), request.getParameterMap());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void streamBundleJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.streamLog(jobId, response.getWriter(), request.getParameterMap());
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void streamCoordinatorJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String logRetrievalScope = request.getParameter("scope");
        String logRetrievalType = request.getParameter("type");
        try {
            coordEngine.streamLog(jobId, logRetrievalScope, logRetrievalType, response.getWriter(), request.getParameterMap());
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected String getJMSTopicName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v1");
    }

    @Override
    protected JSONObject getJobsByParentId(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String coordActionId;
        JSONObject json = new JSONObject();
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String type = request.getParameter("type");
        String scope = request.getParameter("scope");
        if (type != null && type.equals("action") && scope != null) {
            String jobId = this.getResourceName(request);
            coordActionId = Services.get().get(UUIDService.class).generateChildId(jobId, scope);
        } else {
            coordActionId = this.getResourceName(request);
        }
        try {
            List<WorkflowJobBean> wfs = coordEngine.getReruns(coordActionId);
            JSONArray array = new JSONArray();
            if (wfs != null) {
                for (WorkflowJobBean wf : wfs) {
                    JSONObject json1 = new JSONObject();
                    json1.put((Object)"id", (Object)wf.getId());
                    json1.put((Object)"status", (Object)wf.getStatus().toString());
                    json1.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)wf.getStartTime(), (String)"GMT"));
                    json1.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)wf.getEndTime(), (String)"GMT"));
                    array.add((Object)json1);
                }
            }
            json.put((Object)"workflows", (Object)array);
            return json;
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected JSONObject updateJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v1");
    }
}

