/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.ISolutionActionDefinition;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.XForm;

public class InputFormComponent
extends XmlComponent {
    private static final long serialVersionUID = -6106477602576378538L;
    String templateName;
    String stylesheetName;
    String solution;
    String path;
    String actionName;
    String instanceId;
    private static final Log logger = LogFactory.getLog(InputFormComponent.class);

    public InputFormComponent(IPentahoUrlFactory urlFactory, String instanceId, String templateName, String stylesheetName, String solution, String path, String actionName, List messages) {
        super(urlFactory, messages, solution + File.separator + path);
        this.instanceId = instanceId;
        this.templateName = templateName;
        this.stylesheetName = stylesheetName;
        this.solution = solution;
        this.path = path;
        this.actionName = actionName;
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public boolean validate() {
        boolean ok = true;
        if (this.solution == null) {
            this.error(Messages.getInstance().getString("InputForm.ERROR_0001_SOLUTION_NOT_SPECIFIED"));
            ok = false;
        }
        if (this.path == null) {
            this.error(Messages.getInstance().getString("InputForm.ERROR_0002_ACTION_NAME_NOT_SPECIFIED"));
            ok = false;
        }
        if (this.actionName == null) {
            this.error(Messages.getInstance().getString("InputForm.ERROR_0003_ACTION_PATH_NOT_SPECIFIED"));
            ok = false;
        }
        return ok;
    }

    @Override
    public Document getXmlContent() {
        ActionSequenceJCRHelper actionHelper = new ActionSequenceJCRHelper(this.getSession());
        IActionSequence actionSequence = actionHelper.getActionSequence(ActionInfo.buildSolutionPath(this.solution, this.path, this.actionName), this.getLoggingLevel(), RepositoryFilePermission.READ);
        if (actionSequence == null) {
            this.error(Messages.getInstance().getString("InputForm.ERROR_0004_ACTION_NOT_FOUND") + this.solution + this.path + this.actionName);
            return null;
        }
        List actions = actionSequence.getActionDefinitionsAndSequences();
        ISolutionActionDefinition action = (ISolutionActionDefinition)actions.get(0);
        Node node = action.getComponentSection();
        if (node == null) {
            this.error(Messages.getInstance().getString("InputForm.ERROR_0005_INBOX_DEFINITION_MISSING") + this.solution + this.path + this.actionName);
            return null;
        }
        if (this.templateName == null) {
            Node templateNode = node.selectSingleNode("//template");
            if (templateNode != null) {
                this.templateName = templateNode.getText();
            }
            if (this.templateName == null) {
                this.error(Messages.getInstance().getString("InputForm.ERROR_0006_TEMPLATE_NOT_SPECIFIED"));
                return null;
            }
        }
        Node xFormNode = node.selectSingleNode("//xForm");
        try {
            String xFormHtml;
            String description;
            String actionTitle = actionSequence.getTitle();
            if (actionTitle != null) {
                this.setXslProperty("title", actionTitle);
            }
            if ((description = actionSequence.getDescription()) != null) {
                this.setXslProperty("description", description);
            }
            if ((xFormHtml = XForm.transformSnippet(xFormNode, this.getSession(), new SolutionURIResolver())) == null) {
                this.error(Messages.getInstance().getString("InputForm.ERROR_0007_INBOX_DEFINITION_INVALID") + this.solution + this.path + this.actionName);
                return null;
            }
            Document document = DocumentHelper.parseText((String)xFormHtml);
            Node xFormHtmlNode = document.selectSingleNode("//xForm");
            this.setXslProperty("xForm", xFormHtmlNode.asXML());
            if (this.stylesheetName != null && !"".equals(this.stylesheetName)) {
                this.setXslProperty("css", this.stylesheetName);
            }
            this.setXsl("text/html", this.templateName);
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }
}

