/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.util.FileHelper;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.messages.Messages;

public class XmlHelper {
    private static final Pattern RE_ENCODING = Pattern.compile("<\\?xml.*encoding=('|\")([^'\"]*)\\1.*\\?>.*", 32);
    private static final String DEFAULT_XSL_FOLDER = "system/custom/xsl/";
    private static final Log logger = LogFactory.getLog(XmlHelper.class);
    private static final int BUFF_SIZE = 512;

    public static String listToXML(List l) throws UnsupportedOperationException {
        return XmlHelper.listToXML(l, "");
    }

    public static String listToXML(List l, String indent) throws UnsupportedOperationException {
        StringBuffer sb = new StringBuffer();
        sb.append(indent).append("<list>\r");
        String newIndent = indent + "  ";
        for (int i = 0; i < l.size(); ++i) {
            Object obj = l.get(i);
            sb.append(newIndent).append("<list-element>\r");
            XmlHelper.objToXML(obj, sb, newIndent);
            sb.append(newIndent).append("</list-element>\r");
        }
        sb.append(indent).append("</list>\r");
        return sb.toString();
    }

    public static String mapToXML(Map m) throws UnsupportedOperationException {
        return XmlHelper.mapToXML(m, "");
    }

    public static String mapToXML(Map mp, String indent) throws UnsupportedOperationException {
        StringBuffer sb = new StringBuffer();
        sb.append(indent).append("<map>\r");
        String newIndent = indent + "  ";
        for (Map.Entry ent : mp.entrySet()) {
            if (!(ent.getKey() instanceof String)) {
                throw new UnsupportedOperationException(Messages.getInstance().getErrorString("XMLUTL.ERROR_0011_MAP_KEYS"));
            }
            sb.append(newIndent).append("<map-entry>\r");
            sb.append(newIndent).append("<key>\r");
            sb.append(newIndent).append("<![CDATA[").append(ent.getKey().toString()).append("]]>\r");
            sb.append(newIndent).append("</key>\r");
            Object obj = ent.getValue();
            XmlHelper.objToXML(obj, sb, newIndent);
            sb.append(newIndent).append("</map-entry>\r");
        }
        sb.append(indent).append("</map>\r");
        return sb.toString();
    }

    private static void objToXML(Object obj, StringBuffer sb, String newIndent) {
        if (obj instanceof String) {
            sb.append(newIndent).append("<string-value>\r");
            sb.append(newIndent).append("<![CDATA[").append((String)obj).append("]]>\r");
            sb.append(newIndent).append("</string-value>\r");
        } else if (obj instanceof StringBuffer) {
            sb.append(newIndent).append("<stringbuffer-value>\r");
            sb.append(newIndent).append("<![CDATA[").append(obj.toString()).append("]]>\r");
            sb.append(newIndent).append("</stringbuffer-value>\r");
        } else if (obj instanceof BigDecimal) {
            sb.append(newIndent).append("<bigdecimal-value>").append(obj.toString()).append("</bigdecimal-value>\r");
        } else if (obj instanceof Date) {
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append(newIndent).append("<date-value>");
            sb.append(fmt.format((Date)obj)).append("</date-value>\r");
        } else if (obj instanceof Long) {
            sb.append(newIndent).append("<long-value>");
            sb.append(obj.toString()).append("</long-value>\r");
        } else if (obj instanceof Map) {
            sb.append(newIndent).append("<map-value>\r");
            sb.append(XmlHelper.mapToXML((Map)obj, newIndent));
            sb.append(newIndent).append("</map-value>\r");
        } else if (obj instanceof List) {
            sb.append(newIndent).append("<list-value>\r");
            sb.append(XmlHelper.listToXML((List)obj, newIndent));
            sb.append(newIndent).append("</list-value>\r");
        } else {
            throw new UnsupportedOperationException(Messages.getInstance().getErrorString("XMLUTL.ERROR_0012_DATA_TYPE", obj.getClass().getName()));
        }
    }

    public static void decode(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = XmlHelper.decode(strings[i]);
            }
        }
    }

    public static String decode(String string) {
        if (string != null) {
            string = string.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&apos;", "'").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
        }
        return string;
    }

    public static void encode(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = XmlHelper.encode(strings[i]);
            }
        }
    }

    public static String encode(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(File f) throws IOException {
        char[] cbuf = new char[512];
        try (FileReader rdr = null;){
            rdr = new FileReader(f);
            rdr.read(cbuf);
        }
        String strEnc = String.valueOf(cbuf);
        return XmlHelper.getEncoding(strEnc);
    }

    public static String getEncoding(InputStream inStream) throws IOException {
        String encodingPI = XmlHelper.readEncodingProcessingInstruction(inStream);
        return XmlHelper.getEncoding(encodingPI);
    }

    public static String getEncoding(String xml) {
        Matcher m = RE_ENCODING.matcher(xml);
        boolean bMatches = m.matches();
        if (bMatches && m.groupCount() == 2) {
            return m.group(2);
        }
        return null;
    }

    public static String getEncoding(String xml, String defaultEncoding) {
        String enc = XmlHelper.getEncoding(xml);
        return null != enc ? enc : (defaultEncoding != null ? defaultEncoding : LocaleHelper.getSystemEncoding());
    }

    public static String readEncodingProcessingInstruction(InputStream inStream) throws IOException {
        int bytesRead;
        int BUFF_SZ = 256;
        if (inStream.markSupported()) {
            inStream.mark(257);
        }
        byte[] buf = new byte[256];
        int totalBytesRead = 0;
        while ((bytesRead = inStream.read(buf, totalBytesRead, 256 - totalBytesRead)) != -1 && (totalBytesRead += bytesRead) < 256) {
        }
        if (inStream.markSupported()) {
            inStream.reset();
        }
        return new String(buf);
    }

    public static final StringBuffer transformXml(String xslName, String xslPath, String strDocument, Map params, IDocumentResourceLoader loader) throws TransformerException {
        ByteArrayInputStream inStrm;
        block2: {
            inStrm = null;
            try {
                String encoding = XmlHelper.getEncoding(strDocument, null);
                inStrm = new ByteArrayInputStream(strDocument.getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)e);
            }
        }
        StringBuffer result = XmlHelper.transformXml(xslName, xslPath, inStrm, params, loader);
        FileHelper.closeInputStream(inStrm);
        return result;
    }

    public static final StringBuffer transformXml(String xslName, String xslPath, InputStream docInStrm, Map params, IDocumentResourceLoader loader) throws TransformerException {
        StringBuffer result = null;
        InputStream xslInStrm = XmlHelper.getLocalizedXsl(xslPath, xslName, loader);
        if (null == xslInStrm) {
            Logger.error(XmlHelper.class.getName(), Messages.getInstance().getErrorString("XmlHelper.ERROR_0003_NULL_XSL_SOURCE"));
        } else if (null == docInStrm) {
            Logger.error(XmlHelper.class.getName(), Messages.getInstance().getErrorString("XmlHelper.ERROR_0004_NULL_DOCUMENT"));
        } else {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            params.put("output-encoding", LocaleHelper.getSystemEncoding());
            try {
                result = XmlHelper.transformXml(xslInStrm, docInStrm, params, (URIResolver)loader);
            }
            catch (TransformerException e) {
                Logger.error(XmlHelper.class.getName(), Messages.getInstance().getErrorString("XmlHelper.ERROR_0006_TRANSFORM_XML_ERROR", e.getMessage(), xslName), (Throwable)e);
                throw e;
            }
            finally {
                FileHelper.closeInputStream(xslInStrm);
            }
        }
        return result;
    }

    public static final StringBuffer transformXml(InputStream xslInStream, InputStream docInStrm, Map params, URIResolver resolver) throws TransformerConfigurationException, TransformerException {
        StreamSource xslSrc = new StreamSource(xslInStream);
        StreamSource docSrc = new StreamSource(docInStrm);
        return XmlHelper.transformXml(xslSrc, docSrc, params, resolver);
    }

    protected static final StringBuffer transformXml(StreamSource xslSrc, StreamSource docSrc, Map params, URIResolver resolver) throws TransformerConfigurationException, TransformerException {
        StringBuffer sb = null;
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        if (null != resolver) {
            tf.setURIResolver(resolver);
        }
        Transformer t = tf.newTransformer(xslSrc);
        if (params != null) {
            Set keys = params.keySet();
            for (String key : keys) {
                String val = (String)params.get(key);
                if (val == null) continue;
                t.setParameter(key, val);
            }
        }
        t.transform(docSrc, new StreamResult(writer));
        sb = writer.getBuffer();
        return sb;
    }

    public static final InputStream getLocalizedXsl(String path, String xslName, IDocumentResourceLoader loader) {
        String fullPath = null;
        String defaultPath = null;
        InputStream file = null;
        if (null != path) {
            fullPath = (path + File.separator + xslName).replace('\\', '/');
            file = XmlHelper.getLocalizedFile(fullPath, LocaleHelper.getLocale(), loader);
        }
        if (null == file) {
            defaultPath = (DEFAULT_XSL_FOLDER + xslName).replace('\\', '/');
            file = XmlHelper.getLocalizedFile(defaultPath, LocaleHelper.getLocale(), loader);
        }
        if (null == file) {
            Logger.error(XmlHelper.class.getName(), Messages.getInstance().getErrorString("XmlHelper.ERROR_0011_TRANSFORM_XSL_DOES_NOT_EXIST", xslName, fullPath, defaultPath));
        }
        return file;
    }

    public static InputStream getLocalizedFile(String fullPath, Locale locale, IDocumentResourceLoader loader) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String fileName = fullPath;
        int dotIndex = fileName.indexOf(46);
        String baseName = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        String extension = dotIndex == -1 ? "" : fileName.substring(dotIndex);
        InputStream in = null;
        try {
            if (!variant.equals("")) {
                in = loader.loadXsl(baseName + "_" + language + "_" + country + "_" + variant + extension);
            }
            if (in == null) {
                in = loader.loadXsl(baseName + "_" + language + "_" + country + extension);
            }
            if (in == null) {
                in = loader.loadXsl(baseName + "_" + language + extension);
            }
            if (in == null) {
                in = loader.loadXsl(baseName + extension);
            }
        }
        catch (Exception e) {
            Logger.error(XmlHelper.class.getName(), "Error loading localized file: " + fullPath);
        }
        return in;
    }

    public static String createXmlProcessingInstruction(String version, String encoding) {
        return "<?xml version=\"" + version + "\" encoding = \"" + encoding + "\" ?>";
    }
}

