/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.pentaho.di.core.auth.DelegatingKerberosConsumer;
import org.pentaho.di.core.auth.DelegatingKerberosConsumerForClassloaderBridging;
import org.pentaho.di.core.auth.DelegatingNoAuthConsumer;
import org.pentaho.di.core.auth.DelegatingUsernamePasswordConsumer;
import org.pentaho.di.core.auth.KerberosAuthenticationProvider;
import org.pentaho.di.core.auth.KerberosAuthenticationProviderProxyInterface;
import org.pentaho.di.core.auth.NoAuthenticationAuthenticationProvider;
import org.pentaho.di.core.auth.UsernamePasswordAuthenticationProvider;
import org.pentaho.di.core.auth.core.AuthenticationConsumer;
import org.pentaho.di.core.auth.core.AuthenticationConsumerFactory;
import org.pentaho.di.core.auth.core.AuthenticationConsumerInvocationHandler;
import org.pentaho.di.core.auth.core.AuthenticationConsumptionException;
import org.pentaho.di.core.auth.core.AuthenticationFactoryException;
import org.pentaho.di.core.auth.core.AuthenticationManager;
import org.pentaho.di.core.auth.core.AuthenticationPerformer;
import org.pentaho.di.core.auth.core.AuthenticationPerformerFactory;
import org.pentaho.di.core.auth.core.AuthenticationProvider;
import org.pentaho.di.core.auth.core.impl.ClassloaderBridgingAuthenticationPerformer;

public class AuthenticationManagerTest {
    private AuthenticationManager manager;
    private NoAuthenticationAuthenticationProvider noAuthenticationAuthenticationProvider;

    @Before
    public void setup() {
        this.manager = new AuthenticationManager();
        this.noAuthenticationAuthenticationProvider = new NoAuthenticationAuthenticationProvider();
        this.manager.registerAuthenticationProvider((AuthenticationProvider)this.noAuthenticationAuthenticationProvider);
    }

    @Test
    public void testNoAuthProviderAndConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        AuthenticationConsumer consumer = (AuthenticationConsumer)Mockito.mock(AuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, AuthenticationConsumer.class, "NO_AUTH").perform((Object)consumer);
        ((AuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)this.noAuthenticationAuthenticationProvider);
    }

    @Test
    public void testUsernamePasswordProviderConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider);
        AuthenticationConsumer consumer = (AuthenticationConsumer)Mockito.mock(AuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, AuthenticationConsumer.class, usernamePasswordAuthenticationProvider.getId()).perform((Object)consumer);
        ((AuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)usernamePasswordAuthenticationProvider);
    }

    @Test
    public void testKerberosProviderConsumer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumer.class);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)kerberosAuthenticationProvider);
        AuthenticationConsumer consumer = (AuthenticationConsumer)Mockito.mock(AuthenticationConsumer.class);
        this.manager.getAuthenticationPerformer(Object.class, AuthenticationConsumer.class, kerberosAuthenticationProvider.getId()).perform((Object)consumer);
        ((AuthenticationConsumer)Mockito.verify((Object)consumer)).consume((Object)kerberosAuthenticationProvider);
    }

    @Test
    public void testGetSupportedPerformers() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumer.class);
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)kerberosAuthenticationProvider);
        List performers = this.manager.getSupportedAuthenticationPerformers(Object.class, AuthenticationConsumer.class);
        Assert.assertEquals((long)3L, (long)performers.size());
        HashSet<String> ids = new HashSet<String>(Arrays.asList("NO_AUTH", usernamePasswordAuthenticationProvider.getId(), kerberosAuthenticationProvider.getId()));
        for (AuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
    }

    @Test
    public void testRegisterUnregisterProvider() throws AuthenticationFactoryException {
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        List performers = this.manager.getSupportedAuthenticationPerformers(Object.class, AuthenticationConsumer.class);
        Assert.assertEquals((long)1L, (long)performers.size());
        HashSet<String> ids = new HashSet<String>(Arrays.asList("NO_AUTH"));
        for (AuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
        UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider = new UsernamePasswordAuthenticationProvider("upass", "u", "pass");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider);
        performers = this.manager.getSupportedAuthenticationPerformers(Object.class, AuthenticationConsumer.class);
        Assert.assertEquals((long)2L, (long)performers.size());
        ids = new HashSet<String>(Arrays.asList("NO_AUTH", usernamePasswordAuthenticationProvider.getId()));
        for (AuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
        this.manager.unregisterAuthenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider);
        performers = this.manager.getSupportedAuthenticationPerformers(Object.class, AuthenticationConsumer.class);
        Assert.assertEquals((long)1L, (long)performers.size());
        ids = new HashSet<String>(Arrays.asList("NO_AUTH"));
        for (AuthenticationPerformer performer : performers) {
            ids.remove(performer.getAuthenticationProvider().getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
    }

    @Test
    public void testRegisterConsumerFactory() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        AuthenticationConsumer authConsumer = (AuthenticationConsumer)Mockito.mock(AuthenticationConsumer.class);
        AuthenticationConsumerFactory factory = (AuthenticationConsumerFactory)Mockito.mock(AuthenticationConsumerFactory.class);
        Mockito.when((Object)factory.getReturnType()).thenReturn(Object.class);
        Mockito.when((Object)factory.getCreateArgType()).thenReturn(AuthenticationConsumer.class);
        Mockito.when((Object)factory.getConsumedType()).thenReturn(KerberosAuthenticationProvider.class);
        Mockito.when((Object)factory.create((Object)authConsumer)).thenReturn((Object)authConsumer);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)kerberosAuthenticationProvider);
        this.manager.registerConsumerFactory(factory);
        this.manager.getAuthenticationPerformer(Object.class, AuthenticationConsumer.class, kerberosAuthenticationProvider.getId()).perform((Object)authConsumer);
        ((AuthenticationConsumer)Mockito.verify((Object)authConsumer)).consume((Object)kerberosAuthenticationProvider);
    }

    @Test
    public void testClassLoaderBridgingPerformer() throws AuthenticationConsumptionException, AuthenticationFactoryException {
        this.manager.setAuthenticationPerformerFactory(new AuthenticationPerformerFactory(){

            public <ReturnType, CreateArgType, ConsumedType> AuthenticationPerformer<ReturnType, CreateArgType> create(AuthenticationProvider authenticationProvider, AuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumer) {
                if (AuthenticationConsumerInvocationHandler.isCompatible((Class)authenticationConsumer.getConsumedType(), (Object)authenticationProvider)) {
                    return new ClassloaderBridgingAuthenticationPerformer(authenticationProvider, authenticationConsumer);
                }
                return null;
            }
        });
        this.manager.registerConsumerClass(DelegatingNoAuthConsumer.class);
        this.manager.registerConsumerClass(DelegatingUsernamePasswordConsumer.class);
        this.manager.registerConsumerClass(DelegatingKerberosConsumerForClassloaderBridging.class);
        KerberosAuthenticationProvider kerberosAuthenticationProvider = new KerberosAuthenticationProvider("kerb", "kerb", true, "pass", true, "none");
        this.manager.registerAuthenticationProvider((AuthenticationProvider)kerberosAuthenticationProvider);
        AuthenticationConsumer consumer = (AuthenticationConsumer)Mockito.mock(AuthenticationConsumer.class);
        AuthenticationPerformer performer = this.manager.getAuthenticationPerformer(Object.class, AuthenticationConsumer.class, kerberosAuthenticationProvider.getId());
        Assert.assertNotNull((Object)performer);
        performer.perform((Object)consumer);
        ArgumentCaptor captor = ArgumentCaptor.forClass(KerberosAuthenticationProviderProxyInterface.class);
        ((AuthenticationConsumer)Mockito.verify((Object)consumer)).consume(captor.capture());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getId(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).getId());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getDisplayName(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).getDisplayName());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getPrincipal(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).getPrincipal());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getPassword(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).getPassword());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.getKeytabLocation(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).getKeytabLocation());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.isUseKeytab(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).isUseKeytab());
        Assert.assertEquals((Object)kerberosAuthenticationProvider.isUseExternalCredentials(), (Object)((KerberosAuthenticationProviderProxyInterface)captor.getValue()).isUseExternalCredentials());
    }
}

