/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.util.Collection;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.NoneCompressionProvider;
import org.pentaho.di.core.compress.gzip.GZIPCompressionProvider;
import org.pentaho.di.core.compress.hadoopsnappy.HadoopSnappyCompressionProvider;
import org.pentaho.di.core.compress.snappy.SnappyCompressionProvider;
import org.pentaho.di.core.compress.zip.ZIPCompressionProvider;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class CompressionProviderFactoryTest {
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetInstance() {
        Assert.assertNotNull((Object)this.factory);
    }

    @Test
    public void testCreateCoreProviders() {
        CompressionProvider provider = this.factory.createCompressionProviderInstance("None");
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)provider.getClass().isAssignableFrom(NoneCompressionProvider.class));
        Assert.assertEquals((Object)"None", (Object)provider.getName());
        Assert.assertEquals((Object)"No compression", (Object)provider.getDescription());
        provider = this.factory.createCompressionProviderInstance("Zip");
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)provider.getClass().isAssignableFrom(ZIPCompressionProvider.class));
        Assert.assertEquals((Object)"Zip", (Object)provider.getName());
        Assert.assertEquals((Object)"ZIP compression", (Object)provider.getDescription());
        provider = this.factory.createCompressionProviderInstance("GZip");
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)provider.getClass().isAssignableFrom(GZIPCompressionProvider.class));
        Assert.assertEquals((Object)"GZip", (Object)provider.getName());
        Assert.assertEquals((Object)"GZIP compression", (Object)provider.getDescription());
        provider = this.factory.createCompressionProviderInstance("Snappy");
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)provider.getClass().isAssignableFrom(SnappyCompressionProvider.class));
        Assert.assertEquals((Object)"Snappy", (Object)provider.getName());
        Assert.assertEquals((Object)"Snappy compression", (Object)provider.getDescription());
        provider = this.factory.createCompressionProviderInstance("Hadoop-snappy");
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)provider.getClass().isAssignableFrom(HadoopSnappyCompressionProvider.class));
        Assert.assertEquals((Object)"Hadoop-snappy", (Object)provider.getName());
        Assert.assertEquals((Object)"Hadoop Snappy compression", (Object)provider.getDescription());
    }

    @Test
    public void getCoreProviderNames() {
        HashMap<String, Boolean> foundProvider = new HashMap<String, Boolean>(){
            {
                this.put("None", false);
                this.put("Zip", false);
                this.put("GZip", false);
                this.put("Snappy", false);
                this.put("Hadoop-snappy", false);
            }
        };
        String[] providers = this.factory.getCompressionProviderNames();
        Assert.assertNotNull((Object)providers);
        for (String provider : providers) {
            Assert.assertNotNull(foundProvider.get(provider));
            foundProvider.put(provider, true);
        }
        boolean foundAllProviders = true;
        for (Boolean b : foundProvider.values()) {
            foundAllProviders = foundAllProviders && b != false;
        }
        Assert.assertTrue((boolean)foundAllProviders);
    }

    @Test
    public void getCoreProviders() {
        HashMap<String, Boolean> foundProvider = new HashMap<String, Boolean>(){
            {
                this.put("None", false);
                this.put("Zip", false);
                this.put("GZip", false);
                this.put("Snappy", false);
                this.put("Hadoop-snappy", false);
            }
        };
        Collection providers = this.factory.getCompressionProviders();
        Assert.assertNotNull((Object)providers);
        for (CompressionProvider provider : providers) {
            Assert.assertNotNull(foundProvider.get(provider.getName()));
            foundProvider.put(provider.getName(), true);
        }
        boolean foundAllProviders = true;
        for (Boolean b : foundProvider.values()) {
            foundAllProviders = foundAllProviders && b != false;
        }
        Assert.assertTrue((boolean)foundAllProviders);
    }

    @Test
    public void getNonExistentProvider() {
        CompressionProvider provider = this.factory.createCompressionProviderInstance("Fake");
        Assert.assertNull((Object)provider);
        provider = this.factory.getCompressionProviderByName(null);
        Assert.assertNull((Object)provider);
        provider = this.factory.getCompressionProviderByName("Invalid");
        Assert.assertNull((Object)provider);
    }
}

