/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.NoneCompressionProvider;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class NoneCompressionProviderTest {
    public static final String PROVIDER_NAME = "None";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        NoneCompressionProvider ncp = new NoneCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        NoneCompressionProvider provider = (NoneCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        NoneCompressionProvider provider = (NoneCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"No compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertNull((Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        NoneCompressionProvider provider = (NoneCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
        NoneCompressionProvider.NoneCompressionInputStream inStream = new NoneCompressionProvider.NoneCompressionInputStream((InputStream)in, (CompressionProvider)provider);
        Assert.assertNotNull((Object)inStream);
        NoneCompressionProvider.NoneCompressionInputStream ncis = (NoneCompressionProvider.NoneCompressionInputStream)provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        NoneCompressionProvider provider = (NoneCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NoneCompressionProvider.NoneCompressionOutputStream outStream = new NoneCompressionProvider.NoneCompressionOutputStream((OutputStream)out, (CompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        NoneCompressionProvider.NoneCompressionOutputStream ncis = (NoneCompressionProvider.NoneCompressionOutputStream)provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
    }
}

