/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.gzip.GZIPCompressionOutputStream;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class GZIPCompressionOutputStreamTest {
    public static final String PROVIDER_NAME = "GZip";
    public CompressionProviderFactory factory = null;
    public GZIPCompressionOutputStream outStream = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        CompressionProvider provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        this.outStream = new GZIPCompressionOutputStream((OutputStream)in, provider);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.outStream);
    }

    @Test
    public void getCompressionProvider() {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testClose() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new GZIPCompressionOutputStream(out, provider){};
        this.outStream.close();
        try {
            this.outStream.write("This will throw an Exception if the stream is already closed".getBytes());
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testWrite() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new GZIPCompressionOutputStream((OutputStream)out, provider);
        this.outStream.write("Test".getBytes());
    }

    @Test
    public void testAddEntry() throws IOException {
        CompressionProvider provider = this.outStream.getCompressionProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outStream = new GZIPCompressionOutputStream((OutputStream)out, provider);
        this.outStream.addEntry(null, null);
    }
}

