/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobTrackerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddJobTracker() throws Exception {
        String old = System.getProperty("KETTLE_MAX_JOB_TRACKER_SIZE");
        Integer maxTestSize = 30;
        try {
            System.setProperty("KETTLE_MAX_JOB_TRACKER_SIZE", maxTestSize.toString());
            JobMeta jobMeta = (JobMeta)Mockito.mock(JobMeta.class);
            JobTracker jobTracker = new JobTracker(jobMeta);
            for (int n = 0; n < maxTestSize * 2; ++n) {
                jobTracker.addJobTracker((JobTracker)Mockito.mock(JobTracker.class));
            }
            Assert.assertTrue((String)"More JobTrackers than allowed were added", (jobTracker.getTotalNumberOfItems() <= maxTestSize ? 1 : 0) != 0);
        }
        finally {
            if (old == null) {
                System.clearProperty("KETTLE_MAX_JOB_TRACKER_SIZE");
            } else {
                System.setProperty("KETTLE_MAX_JOB_TRACKER_SIZE", old);
            }
        }
    }

    @Test
    public void findJobTracker_EntryNameIsNull() {
        JobTracker jobTracker = JobTrackerTest.createTracker();
        jobTracker.addJobTracker(JobTrackerTest.createTracker());
        JobEntryCopy copy = JobTrackerTest.createEntryCopy(null);
        Assert.assertNull((Object)jobTracker.findJobTracker(copy));
    }

    @Test
    public void findJobTracker_EntryNameNotFound() {
        JobTracker jobTracker = JobTrackerTest.createTracker();
        for (int i = 0; i < 3; ++i) {
            jobTracker.addJobTracker(JobTrackerTest.createTracker(Integer.toString(i), 1));
        }
        JobEntryCopy copy = JobTrackerTest.createEntryCopy("not match");
        Assert.assertNull((Object)jobTracker.findJobTracker(copy));
    }

    @Test
    public void findJobTracker_EntryNameFound() {
        JobTracker[] children;
        JobTracker jobTracker = JobTrackerTest.createTracker();
        for (JobTracker child : children = new JobTracker[]{JobTrackerTest.createTracker("0", 1), JobTrackerTest.createTracker("1", 1), JobTrackerTest.createTracker("2", 1)}) {
            jobTracker.addJobTracker(child);
        }
        JobEntryCopy copy = JobTrackerTest.createEntryCopy("1");
        Assert.assertEquals((Object)children[1], (Object)jobTracker.findJobTracker(copy));
    }

    private static JobTracker createTracker() {
        return JobTrackerTest.createTracker(null, -1);
    }

    private static JobTracker createTracker(String jobEntryName, int jobEntryNr) {
        JobMeta jobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        JobTracker jobTracker = new JobTracker(jobMeta);
        if (jobEntryName != null) {
            JobEntryResult result = (JobEntryResult)Mockito.mock(JobEntryResult.class);
            Mockito.when((Object)result.getJobEntryName()).thenReturn((Object)jobEntryName);
            Mockito.when((Object)result.getJobEntryNr()).thenReturn((Object)jobEntryNr);
            jobTracker.setJobEntryResult(result);
        }
        return jobTracker;
    }

    private static JobEntryCopy createEntryCopy(String entryName) {
        JobEntryInterface entry = (JobEntryInterface)Mockito.mock(JobEntryInterface.class);
        Mockito.when((Object)entry.getName()).thenReturn((Object)entryName);
        JobEntryCopy copy = new JobEntryCopy(entry);
        copy.setNr(1);
        return copy;
    }
}

