/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.KettleLifecycleSupport;
import org.pentaho.di.core.lifecycle.LifecycleSupport;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;

public class KettleLifecycleSupportTest {
    private PluginRegistry registry;
    private List<PluginInterface> registeredPlugins;
    private ArgumentCaptor<PluginTypeListener> typeListenerRegistration;

    @Before
    public void setUpPluginRegistry() throws Exception {
        LifecycleSupport.registry = KettleLifecycleSupport.registry = (PluginRegistry)Mockito.mock(PluginRegistry.class);
        this.registry = KettleLifecycleSupport.registry;
        this.registeredPlugins = new ArrayList<PluginInterface>();
        Mockito.when((Object)this.registry.getPlugins(KettleLifecyclePluginType.class)).thenReturn(this.registeredPlugins);
        this.typeListenerRegistration = ArgumentCaptor.forClass(PluginTypeListener.class);
        ((PluginRegistry)Mockito.doNothing().when((Object)this.registry)).addPluginListener((Class)Matchers.eq(KettleLifecyclePluginType.class), (PluginTypeListener)this.typeListenerRegistration.capture());
    }

    @Test
    public void testOnEnvironmentInit() throws Exception {
        final ArrayList<KettleLifecycleListener> listeners = new ArrayList<KettleLifecycleListener>();
        listeners.add(this.createLifecycleListener());
        KettleLifecycleSupport kettleLifecycleSupport = new KettleLifecycleSupport();
        Assert.assertNotNull((Object)this.typeListenerRegistration.getValue());
        KettleLifecycleListener preInit = this.createLifecycleListener();
        listeners.add(preInit);
        ((KettleLifecycleListener)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listeners.add(KettleLifecycleSupportTest.this.createLifecycleListener());
                return null;
            }
        }).when((Object)preInit)).onEnvironmentInit();
        Mockito.verifyNoMoreInteractions((Object[])listeners.toArray());
        kettleLifecycleSupport.onEnvironmentInit();
        for (KettleLifecycleListener listener : listeners) {
            ((KettleLifecycleListener)Mockito.verify((Object)listener)).onEnvironmentInit();
        }
        Mockito.verifyNoMoreInteractions((Object[])listeners.toArray());
        KettleLifecycleListener postInit = this.createLifecycleListener();
        ((KettleLifecycleListener)Mockito.verify((Object)postInit)).onEnvironmentInit();
        Mockito.verifyNoMoreInteractions((Object[])listeners.toArray());
    }

    private KettleLifecycleListener createLifecycleListener() throws KettlePluginException {
        PluginInterface pluginInterface = (PluginInterface)Mockito.mock(PluginInterface.class);
        KettleLifecycleListener kettleLifecycleListener = (KettleLifecycleListener)Mockito.mock(KettleLifecycleListener.class);
        this.registeredPlugins.add(pluginInterface);
        Mockito.when((Object)this.registry.loadClass(pluginInterface, KettleLifecycleListener.class)).thenReturn((Object)kettleLifecycleListener);
        Mockito.when((Object)this.registry.loadClass(pluginInterface)).thenReturn((Object)kettleLifecycleListener);
        if (!this.typeListenerRegistration.getAllValues().isEmpty()) {
            ((PluginTypeListener)this.typeListenerRegistration.getValue()).pluginAdded((Object)pluginInterface);
        }
        return kettleLifecycleListener;
    }
}

