/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.logging.PerformanceLogTable;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.HasDatabasesInterface;

public class LogTableTest {
    private static String PARAM_START_SYMBOL = "${";
    private static String PARAM_END_SYMBOL = "}";
    private static String GLOBAL_PARAM = PARAM_START_SYMBOL + "KETTLE_STEP_LOG_DB" + PARAM_END_SYMBOL;
    private static String USER_PARAM = PARAM_START_SYMBOL + "param-content" + PARAM_END_SYMBOL;
    private static String HARDCODED_VALUE = "hardcoded";
    private VariableSpace mockedVariableSpace;
    private HasDatabasesInterface mockedHasDbInterface;

    @Before
    public void init() {
        System.setProperty("KETTLE_STEP_LOG_DB", "KETTLE_STEP_LOG_DB_VALUE");
        this.mockedVariableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.mockedHasDbInterface = (HasDatabasesInterface)Mockito.mock(HasDatabasesInterface.class);
    }

    @Test
    public void hardcodedFieldsNotChanged() {
        this.tableFieldsChangedCorrectlyAfterNullingGlobalParams(HARDCODED_VALUE, HARDCODED_VALUE);
    }

    @Test
    public void userParamsFieldsNotChanged() {
        this.tableFieldsChangedCorrectlyAfterNullingGlobalParams(USER_PARAM, USER_PARAM);
    }

    @Test
    public void globalParamsFieldsAreNulled() {
        this.tableFieldsChangedCorrectlyAfterNullingGlobalParams(GLOBAL_PARAM, null);
    }

    public void tableFieldsChangedCorrectlyAfterNullingGlobalParams(String valueForAllFields, String expectedAfterNullingGlobalParams) {
        PerformanceLogTable performanceLogTable = this.getPerformanceLogTableWithAllEqFields(valueForAllFields);
        performanceLogTable.setAllGlobalParametersToNull();
        this.commonTableFieldsValueChecker((BaseLogTable)performanceLogTable, expectedAfterNullingGlobalParams);
        Assert.assertEquals((String)performanceLogTable.getLogInterval(), (String)expectedAfterNullingGlobalParams);
        JobLogTable jobLogTable = this.getJobLogTableWithAllEqFields(valueForAllFields);
        jobLogTable.setAllGlobalParametersToNull();
        this.commonTableFieldsValueChecker((BaseLogTable)jobLogTable, expectedAfterNullingGlobalParams);
        Assert.assertEquals((String)jobLogTable.getLogInterval(), (String)expectedAfterNullingGlobalParams);
        Assert.assertEquals((String)jobLogTable.getLogSizeLimit(), (String)expectedAfterNullingGlobalParams);
        TransLogTable transLogTable = this.getTransLogTableWithAllEqFields(valueForAllFields);
        transLogTable.setAllGlobalParametersToNull();
        this.commonTableFieldsValueChecker((BaseLogTable)transLogTable, expectedAfterNullingGlobalParams);
        Assert.assertEquals((String)transLogTable.getLogInterval(), (String)expectedAfterNullingGlobalParams);
        Assert.assertEquals((String)transLogTable.getLogSizeLimit(), (String)expectedAfterNullingGlobalParams);
    }

    private PerformanceLogTable getPerformanceLogTableWithAllEqFields(String fieldsValue) {
        PerformanceLogTable performanceLogTable = PerformanceLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.mockedHasDbInterface);
        this.initCommonTableFields((BaseLogTable)performanceLogTable, fieldsValue);
        performanceLogTable.setLogInterval(fieldsValue);
        return performanceLogTable;
    }

    private JobLogTable getJobLogTableWithAllEqFields(String fieldsValue) {
        JobLogTable jobLogTable = JobLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.mockedHasDbInterface);
        this.initCommonTableFields((BaseLogTable)jobLogTable, fieldsValue);
        jobLogTable.setLogSizeLimit(fieldsValue);
        jobLogTable.setLogInterval(fieldsValue);
        return jobLogTable;
    }

    private TransLogTable getTransLogTableWithAllEqFields(String fieldsValue) {
        TransLogTable transLogTable = TransLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.mockedHasDbInterface, null);
        this.initCommonTableFields((BaseLogTable)transLogTable, fieldsValue);
        transLogTable.setLogInterval(fieldsValue);
        transLogTable.setLogSizeLimit(fieldsValue);
        return transLogTable;
    }

    private void initCommonTableFields(BaseLogTable logTable, String value) {
        logTable.setTableName(value);
        logTable.setConnectionName(value);
        logTable.setSchemaName(value);
        logTable.setTimeoutInDays(value);
    }

    private void commonTableFieldsValueChecker(BaseLogTable logTable, String expectedForAllFields) {
        Assert.assertEquals((String)logTable.getTableName(), (String)expectedForAllFields);
        Assert.assertEquals((String)logTable.getConnectionName(), (String)expectedForAllFields);
        Assert.assertEquals((String)logTable.getSchemaName(), (String)expectedForAllFields);
        Assert.assertEquals((String)logTable.getTimeoutInDays(), (String)expectedForAllFields);
    }
}

