/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class JobExportIT {
    private static final String FILE_REPOSITORY_ID = "KettleFileRepository";
    private static final String FILE_REPOSITORY_NAME = "FileRep";
    private static final String FILE_REPOSITORY_DESC = "File repository";
    private static final String EXPORT_FILE_NAME = "sample_job_export.zip";
    private static final String EXPORT_DIR = "test-src/org/pentaho/di/job/out/";
    private static final String EXPORT_FILE = "test-src/org/pentaho/di/job/out/sample_job_export.zip";
    private static final String REPOSITORY_ROOT_DIR = "test-src/org/pentaho/di/job/repo";
    private static final String REPOSITORY_DIR = "/folder";
    private static final String JOB_NAME = "sample_job";
    private static final String EXTRACT_DIR = "test-src/org/pentaho/di/job/out/" + File.separator + "sample_job";
    private static final String EXTRACTED_JOB_FILE = EXTRACT_DIR + File.separator + "sample_job" + ".kjb";
    private static final String EXTRACTED_TRANS_FILE = EXTRACT_DIR + File.separator + "sample_trans.ktr";
    private KettleFileRepository repository;

    @BeforeClass
    public static void setUpOnce() throws KettleException {
        JobExportIT.deleteFolder(new File(EXPORT_DIR));
        new File(EXPORT_DIR).mkdir();
        KettleEnvironment.init();
    }

    @AfterClass
    public static void tearDownOnce() {
        JobExportIT.deleteFolder(new File(EXPORT_DIR));
    }

    @Before
    public void setUp() throws KettleException {
        KettleFileRepositoryMeta repositoryMeta = new KettleFileRepositoryMeta(FILE_REPOSITORY_ID, FILE_REPOSITORY_NAME, FILE_REPOSITORY_DESC, REPOSITORY_ROOT_DIR);
        this.repository = new KettleFileRepository();
        this.repository.init((RepositoryMeta)repositoryMeta);
        this.repository.connect(null, null);
    }

    @After
    public void tearDown() {
        this.repository.disconnect();
    }

    @Test
    public void shouldExportJobAndRelatedTransformationFile() throws IOException, MetaStoreException, KettleException {
        RepositoryDirectoryInterface repositoryDir = this.repository.loadRepositoryDirectoryTree();
        repositoryDir = repositoryDir.findDirectory(REPOSITORY_DIR);
        JobMeta jobMeta = this.repository.loadJob(JOB_NAME, repositoryDir, null, null);
        Job job = new Job((Repository)this.repository, jobMeta);
        ResourceUtil.serializeResourceExportInterface((String)EXPORT_FILE, (ResourceExportInterface)job.getJobMeta(), (VariableSpace)job, (Repository)this.repository, null);
        File zipFile = new File(EXPORT_FILE);
        Assert.assertTrue((boolean)zipFile.exists());
        JobExportIT.extractZip(zipFile, EXTRACT_DIR);
        Assert.assertTrue((boolean)new File(EXTRACTED_JOB_FILE).exists());
        Assert.assertTrue((boolean)new File(EXTRACTED_TRANS_FILE).exists());
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    JobExportIT.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    private static void extractZip(File zipFile, String extractDir) throws IOException {
        int BUFFER = 2048;
        ZipFile zip = new ZipFile(zipFile);
        new File(extractDir).mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(extractDir, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }
}

