/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evaluatetablecontent;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockDriver
implements Driver {
    private static final List<MockDriver> drivers = new ArrayList<MockDriver>();

    public static synchronized void registerInstance() throws SQLException {
        MockDriver driver = new MockDriver();
        DriverManager.registerDriver(driver);
        drivers.add(driver);
    }

    public static synchronized void deregeisterInstances() throws SQLException {
        for (Driver driver : drivers) {
            DriverManager.deregisterDriver(driver);
        }
        drivers.clear();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return true;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData md = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)stmt.getMaxRows()).thenReturn((Object)5);
        Mockito.when((Object)stmt.getResultSet()).thenReturn((Object)rs);
        Mockito.when((Object)stmt.executeQuery(Matchers.anyString())).thenReturn((Object)rs);
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)md);
        Mockito.when((Object)rs.getLong(Matchers.anyInt())).thenReturn((Object)5L);
        Mockito.when((Object)rs.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int count = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return this.count++ == 0;
            }
        });
        Mockito.when((Object)md.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)md.getColumnName(Matchers.anyInt())).thenReturn((Object)"count");
        Mockito.when((Object)md.getColumnType(Matchers.anyInt())).thenReturn((Object)4);
        Mockito.when((Object)conn.createStatement()).thenReturn((Object)stmt);
        return conn;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }
}

