/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.filesexist;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.filesexist.JobEntryFilesExist;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.utils.TestUtils;

public class JobEntryFilesExistTest {
    private Job job;
    private JobEntryFilesExist entry;
    private String existingFile1;
    private String existingFile2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleLogStore.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.job = new Job(null, new JobMeta());
        this.entry = new JobEntryFilesExist();
        this.job.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.entry));
        this.entry.setParentJob(this.job);
        this.job.setStopped(false);
        this.existingFile1 = TestUtils.createRamFile(this.getClass().getSimpleName() + "/existingFile1.ext");
        this.existingFile2 = TestUtils.createRamFile(this.getClass().getSimpleName() + "/existingFile2.ext");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSetNrErrorsNewBehaviorFalseResult() throws Exception {
        this.entry.arguments = new String[]{"nonExistingFile.ext"};
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Entry should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"Files not found. Result is false. But... No of errors should be zero", (long)0L, (long)res.getNrErrors());
    }

    @Test
    public void testSetNrErrorsOldBehaviorFalseResult() throws Exception {
        this.entry.arguments = new String[]{"nonExistingFile1.ext", "nonExistingFile2.ext"};
        this.entry.setVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "Y");
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Entry should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"Files not found. Result is false. And... Number of errors should be the same as number of not found files", (long)this.entry.arguments.length, (long)res.getNrErrors());
    }

    @Test
    public void testExecuteWithException() throws Exception {
        this.entry.arguments = new String[]{null};
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Entry should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"File with wrong name was specified. One error should be reported", (long)1L, (long)res.getNrErrors());
    }

    @Test
    public void testExecuteSuccess() throws Exception {
        this.entry.arguments = new String[]{this.existingFile1, this.existingFile2};
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Entry failed", (boolean)res.getResult());
    }

    @Test
    public void testExecuteFail() throws Exception {
        this.entry.arguments = new String[]{this.existingFile1, this.existingFile2, "nonExistingFile1.ext", "nonExistingFile2.ext"};
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Entry should fail", (boolean)res.getResult());
    }
}

