/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpput;

import com.enterprisedt.net.ftp.FTPClient;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.job.entries.ftpput.JobEntryFTPPUT;

public class JobEntryFTPPUTTest {
    private JobEntryFTPPUT entry;
    private FTPClient ftpClient;

    @Before
    public void setUp() throws Exception {
        this.ftpClient = (FTPClient)Mockito.mock(FTPClient.class);
        this.entry = (JobEntryFTPPUT)Mockito.spy((Object)new JobEntryFTPPUT());
        ((JobEntryFTPPUT)Mockito.doReturn((Object)this.ftpClient).when((Object)this.entry)).createFtpClient();
    }

    @Test
    public void createFtpClient_SetsLocalhostByDefault() throws Exception {
        this.entry.setServerName(null);
        this.entry.createAndSetUpFtpClient();
        Assert.assertEquals((Object)"localhost", (Object)this.getHostFromClient());
    }

    @Test
    public void createFtpClient_DoesNotChangePortByDefault() throws Exception {
        this.entry.setServerPort(null);
        this.entry.createAndSetUpFtpClient();
        ((FTPClient)Mockito.verify((Object)this.ftpClient, (VerificationMode)Mockito.never())).setRemotePort(Mockito.anyInt());
    }

    @Test
    public void createFtpClient_UsesProxyIfSet() throws Exception {
        this.entry.setProxyHost("localhost");
        this.entry.setProxyPort("123");
        this.entry.createAndSetUpFtpClient();
        Assert.assertEquals((Object)"localhost", (Object)this.getHostFromClient());
        ((FTPClient)Mockito.verify((Object)this.ftpClient, (VerificationMode)Mockito.times((int)2))).setRemoteAddr(InetAddress.getByName("localhost"));
        ((FTPClient)Mockito.verify((Object)this.ftpClient)).setRemotePort(123);
    }

    @Test
    public void createFtpClient_UsesTimeoutIfSet() throws Exception {
        this.entry.setTimeout(10);
        this.entry.createAndSetUpFtpClient();
        ((FTPClient)Mockito.verify((Object)this.ftpClient)).setTimeout(10);
    }

    private String getHostFromClient() throws Exception {
        ArgumentCaptor addrCaptor = ArgumentCaptor.forClass(InetAddress.class);
        ((FTPClient)Mockito.verify((Object)this.ftpClient, (VerificationMode)Mockito.atLeastOnce())).setRemoteAddr((InetAddress)addrCaptor.capture());
        return ((InetAddress)addrCaptor.getValue()).getHostName();
    }
}

