/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.zipfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.zipfile.JobEntryZipFile;

public class JobEntryZipFileIT {
    @BeforeClass
    public static void init() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void processFileIndicatesFailure() throws Exception {
        JobEntryZipFile entry = new JobEntryZipFile();
        Assert.assertFalse((boolean)entry.processRowFile(new Job(), new Result(), "file://\nfake-path\n", null, null, null, null, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void processFile_ReturnsTrue_OnSuccess() throws Exception {
        String zipPath = "ram://pdi-15013.zip";
        String content = "temp file";
        File tempFile = JobEntryZipFileIT.createTempFile("temp file");
        tempFile.deleteOnExit();
        try {
            Result result = new Result();
            JobEntryZipFile entry = new JobEntryZipFile();
            Assert.assertTrue((boolean)entry.processRowFile(new Job(), result, "ram://pdi-15013.zip", null, null, tempFile.getAbsolutePath(), null, false));
        }
        finally {
            tempFile.delete();
        }
        FileObject zip = KettleVFS.getFileObject((String)"ram://pdi-15013.zip");
        Assert.assertTrue((String)"Zip archive should be created", (boolean)zip.exists());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)zip.getContent().getInputStream(), (OutputStream)os);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(os.toByteArray()));
        ZipEntry entry = zis.getNextEntry();
        Assert.assertEquals((String)"Input file should be put into the archive", (Object)tempFile.getName(), (Object)entry.getName());
        os.reset();
        IOUtils.copy((InputStream)zis, (OutputStream)os);
        Assert.assertEquals((String)"File's content should be equal to original", (Object)"temp file", (Object)new String(os.toByteArray()));
    }

    private static File createTempFile(String content) throws Exception {
        File file = File.createTempFile("JobEntryZipFileIT", ".txt");
        try (PrintWriter pw = new PrintWriter(file);){
            pw.print(content);
        }
        return file;
    }
}

