/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobEntryCopyTest {
    private JobEntryCopy originJobEntry;
    private JobEntryCopy copyJobEntry;
    private JobEntryInterface originEntry;

    @Before
    public void setUp() throws Exception {
        this.originJobEntry = new JobEntryCopy();
        this.copyJobEntry = new JobEntryCopy();
        this.originEntry = new JobEntrySpecial("EntrySpecial", false, false);
        this.originEntry.setChanged(false);
        this.originJobEntry.setEntry(this.originEntry);
    }

    @Test
    public void testReplaceMetaCloneEntryOfOrigin() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertNotSame((String)"Entry of origin and copy JobEntry should be different objects: ", (Object)this.copyJobEntry.getEntry(), (Object)this.originJobEntry.getEntry());
    }

    @Test
    public void testReplaceMetaDoesNotChangeEntryOfOrigin() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertEquals((String)"hasChanged in Entry of origin JobEntry should not be changed. ", (Object)false, (Object)this.originJobEntry.getEntry().hasChanged());
    }

    @Test
    public void testReplaceMetaChangesEntryOfCopy() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertEquals((String)"hasChanged in Entry of copy JobEntry should be changed. ", (Object)true, (Object)this.copyJobEntry.getEntry().hasChanged());
    }
}

