/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.loadSave;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.di.trans.steps.loadsave.validator.DefaultFieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.test.util.JavaBeanManipulator;

abstract class LoadSaveBase<T> {
    final Class<T> clazz;
    final List<String> xmlAttributes;
    final List<String> repoAttributes;
    final JavaBeanManipulator<T> manipulator;
    final FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory;

    public LoadSaveBase(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this.clazz = clazz;
        this.xmlAttributes = LoadSaveBase.concat(commonAttributes, xmlAttributes);
        this.repoAttributes = LoadSaveBase.concat(commonAttributes, repoAttributes);
        this.manipulator = new JavaBeanManipulator<T>(clazz, LoadSaveBase.concat(this.xmlAttributes, repoAttributes), getterMap, setterMap);
        HashMap fieldLoadSaveValidatorMethodMap = new HashMap(fieldLoadSaveValidatorAttributeMap.size());
        for (Map.Entry<String, FieldLoadSaveValidator<?>> entry : fieldLoadSaveValidatorAttributeMap.entrySet()) {
            fieldLoadSaveValidatorMethodMap.put(this.manipulator.getGetter(entry.getKey()), entry.getValue());
        }
        this.fieldLoadSaveValidatorFactory = new DefaultFieldLoadSaveValidatorFactory(fieldLoadSaveValidatorMethodMap, fieldLoadSaveValidatorTypeMap);
    }

    public T createMeta() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create meta of class " + this.clazz.getCanonicalName(), e);
        }
    }

    Map<String, FieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, T metaToSave) {
        HashMap validatorMap = new HashMap();
        for (String attribute : attributes) {
            Getter<?> getter = this.manipulator.getGetter(attribute);
            Setter<?> setter = this.manipulator.getSetter(attribute);
            FieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                setter.set(metaToSave, validator.getTestObject());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    void validateLoadedMeta(List<String> attributes, Map<String, FieldLoadSaveValidator<?>> validatorMap, T metaSaved, T metaLoaded) {
        for (String attribute : attributes) {
            try {
                Getter<?> getterMethod = this.manipulator.getGetter(attribute);
                Object originalValue = getterMethod.get(metaSaved);
                Object value = getterMethod.get(metaLoaded);
                FieldLoadSaveValidator<?> validator = validatorMap.get(attribute);
                Method[] validatorMethods = validator.getClass().getMethods();
                Method validatorMethod = null;
                for (Method method : validatorMethods) {
                    Class<?>[] types;
                    if (!"validateTestObject".equals(method.getName()) || (types = method.getParameterTypes()).length != 2 || types[1] != Object.class || originalValue != null && !types[0].isAssignableFrom(originalValue.getClass())) continue;
                    validatorMethod = method;
                    break;
                }
                if (validatorMethod == null) {
                    throw new RuntimeException("Couldn't find proper validateTestObject method on " + validator.getClass().getCanonicalName());
                }
                if (((Boolean)validatorMethod.invoke(validator, originalValue, value)).booleanValue()) continue;
                throw new KettleException("Attribute " + attribute + " started with value " + originalValue + " ended with value " + value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error validating " + attribute, e);
            }
        }
    }

    private static <E> List<E> concat(List<E> list1, List<E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }
}

