/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.pan.Pan;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;

public class PanTest {
    private static final String TEST_PARAM_NAME = "testParam";
    private static final String DEFAULT_PARAM_VALUE = "default value";
    private static final String NOT_DEFAULT_PARAM_VALUE = "not the default value";

    @BeforeClass
    public static void setUp() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void testConfigureParameters() throws Exception {
        TransMeta transMeta = new TransMeta();
        transMeta.addParameterDefinition(TEST_PARAM_NAME, DEFAULT_PARAM_VALUE, "This tests a default parameter");
        Assert.assertEquals((String)"Default parameter was not set correctly on TransMeta", (Object)DEFAULT_PARAM_VALUE, (Object)transMeta.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in TransMeta", (Object)"", (Object)transMeta.getParameterValue(TEST_PARAM_NAME));
        Trans trans = new Trans(transMeta);
        Assert.assertEquals((String)"Default parameter was not set correctly on Trans", (Object)DEFAULT_PARAM_VALUE, (Object)trans.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in Trans", (Object)"", (Object)trans.getParameterValue(TEST_PARAM_NAME));
        NamedParamsDefault params = new NamedParamsDefault();
        params.addParameterDefinition(TEST_PARAM_NAME, NOT_DEFAULT_PARAM_VALUE, "This tests a non-default parameter");
        params.setParameterValue(TEST_PARAM_NAME, NOT_DEFAULT_PARAM_VALUE);
        Pan.configureParameters((Trans)trans, (NamedParams)params, (TransMeta)transMeta);
        Assert.assertEquals((String)"Parameter was not set correctly in Trans", (Object)NOT_DEFAULT_PARAM_VALUE, (Object)trans.getParameterValue(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter was not set correctly in TransMeta", (Object)NOT_DEFAULT_PARAM_VALUE, (Object)transMeta.getParameterValue(TEST_PARAM_NAME));
    }
}

