/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;

public class TransMetaTest {
    private TransMeta transMeta;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.transMeta = new TransMeta();
    }

    @Test
    public void testGetMinimum() {
        Point minimalCanvasPoint = new Point(0, 0);
        Point stepPoint = new Point(500, 500);
        Point point = this.transMeta.getMinimum();
        Assert.assertEquals((long)minimalCanvasPoint.x, (long)point.x);
        Assert.assertEquals((long)minimalCanvasPoint.y, (long)point.y);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getLocation()).thenReturn((Object)stepPoint);
        this.transMeta.addStep(stepMeta);
        Point actualStepPoint = this.transMeta.getMinimum();
        Assert.assertEquals((long)(stepPoint.x - 20), (long)actualStepPoint.x);
        Assert.assertEquals((long)(stepPoint.y - 20), (long)actualStepPoint.y);
    }

    @Test
    public void getThisStepFieldsPassesCloneRowMeta() throws Exception {
        String overriddenValue = "overridden";
        StepMeta nextStep = TransMetaTest.mockStepMeta("nextStep");
        StepMetaInterface smi = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
        StepIOMeta ioMeta = (StepIOMeta)Mockito.mock(StepIOMeta.class);
        Mockito.when((Object)smi.getStepIOMeta()).thenReturn((Object)ioMeta);
        ((StepMetaInterface)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RowMetaInterface rmi = (RowMetaInterface)invocation.getArguments()[0];
                rmi.clear();
                rmi.addValueMeta((ValueMetaInterface)new ValueMetaString("overridden"));
                return null;
            }
        }).when((Object)smi)).getFields((RowMetaInterface)Mockito.any(RowMetaInterface.class), Mockito.anyString(), (RowMetaInterface[])Mockito.any(RowMetaInterface[].class), (StepMeta)Mockito.eq((Object)nextStep), (VariableSpace)Mockito.any(VariableSpace.class), (Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class));
        StepMeta thisStep = TransMetaTest.mockStepMeta("thisStep");
        Mockito.when((Object)thisStep.getStepMetaInterface()).thenReturn((Object)smi);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("value"));
        RowMetaInterface thisStepsFields = this.transMeta.getThisStepFields(thisStep, nextStep, (RowMetaInterface)rowMeta);
        Assert.assertEquals((long)1L, (long)thisStepsFields.size());
        Assert.assertEquals((Object)"overridden", (Object)thisStepsFields.getValueMeta(0).getName());
    }

    @Test
    public void testDatabaseNotOverridden() throws Exception {
        String name = "db meta";
        DatabaseMeta dbMetaShared = new DatabaseMeta();
        dbMetaShared.setName("db meta");
        dbMetaShared.setHostname("host");
        DatabaseMeta dbMetaStore = new DatabaseMeta();
        dbMetaStore.setName("db meta");
        dbMetaStore.setHostname("anotherhost");
        MemoryMetaStore mstore = new MemoryMetaStore();
        DatabaseMetaStoreUtil.createDatabaseElement((IMetaStore)mstore, (DatabaseMeta)dbMetaStore);
        TransMeta trans = new TransMeta();
        trans.addOrReplaceDatabase(dbMetaShared);
        trans.setMetaStore((IMetaStore)mstore);
        trans.importFromMetaStore();
        DatabaseMeta dbMeta = trans.findDatabase("db meta");
        Assert.assertEquals((Object)dbMetaShared.getHostname(), (Object)dbMeta.getHostname());
    }

    @Test
    public void testAddOrReplaceStep() throws Exception {
        StepMeta stepMeta = TransMetaTest.mockStepMeta("ETL Metadata Injection");
        MetaInjectMeta stepMetaInterfaceMock = (MetaInjectMeta)Mockito.mock(MetaInjectMeta.class);
        Mockito.when((Object)stepMeta.getStepMetaInterface()).thenReturn((Object)stepMetaInterfaceMock);
        this.transMeta.addOrReplaceStep(stepMeta);
        ((StepMeta)Mockito.verify((Object)stepMeta)).setParentTransMeta((TransMeta)Mockito.any(TransMeta.class));
        assert (this.transMeta.steps.size() == 1);
        assert (this.transMeta.changed_steps);
    }

    @Test
    public void testStepChangeListener() throws Exception {
        MetaInjectMeta mim = new MetaInjectMeta();
        StepMeta sm = new StepMeta("testStep", (StepMetaInterface)mim);
        try {
            this.transMeta.addOrReplaceStep(sm);
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }

    @Test
    public void testContentChangeListener() throws Exception {
        ContentChangedListener listener = (ContentChangedListener)Mockito.mock(ContentChangedListener.class);
        this.transMeta.addContentChangedListener(listener);
        this.transMeta.setChanged();
        this.transMeta.setChanged(true);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.same((Object)this.transMeta));
        this.transMeta.clearChanged();
        this.transMeta.setChanged(false);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentSafe(Matchers.same((Object)this.transMeta));
        this.transMeta.removeContentChangedListener(listener);
        this.transMeta.setChanged();
        this.transMeta.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testCompare() throws Exception {
        TransMeta transMeta = new TransMeta("aFile", "aName");
        TransMeta transMeta2 = new TransMeta("aFile", "aName");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        transMeta2.setVariable("myVariable", "myValue");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        transMeta2.setFilename(null);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile");
        transMeta2.setName(null);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile2");
        transMeta2.setName("aName");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta2.setFilename("aFile");
        transMeta2.setName("aName2");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        transMeta.setFilename(null);
        transMeta2.setFilename(null);
        transMeta2.setName("aName");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        RepositoryDirectoryInterface path1 = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        transMeta.setRepositoryDirectory(path1);
        Mockito.when((Object)path1.getPath()).thenReturn((Object)"aPath2");
        RepositoryDirectoryInterface path2 = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)path2.getPath()).thenReturn((Object)"aPath");
        transMeta2.setRepositoryDirectory(path2);
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta2, transMeta));
        Mockito.when((Object)path1.getPath()).thenReturn((Object)"aPath");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        ObjectRevision revision2 = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        transMeta2.setObjectRevision(revision2);
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
        ObjectRevision revision1 = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        transMeta.setObjectRevision(revision1);
        Mockito.when((Object)revision1.getName()).thenReturn((Object)"aRevision");
        Mockito.when((Object)revision2.getName()).thenReturn((Object)"aRevision");
        Assert.assertEquals((long)0L, (long)transMeta.compare(transMeta, transMeta2));
        Mockito.when((Object)revision2.getName()).thenReturn((Object)"aRevision2");
        Assert.assertEquals((long)-1L, (long)transMeta.compare(transMeta, transMeta2));
        Assert.assertEquals((long)1L, (long)transMeta.compare(transMeta2, transMeta));
    }

    @Test
    public void testEquals() throws Exception {
        TransMeta transMeta = new TransMeta("1", "2");
        Assert.assertFalse((boolean)transMeta.equals((Object)"somethingelse"));
        Assert.assertTrue((boolean)transMeta.equals((Object)new TransMeta("1", "2")));
    }

    @Test
    public void testTransHops() throws Exception {
        TransMeta transMeta = new TransMeta("transFile", "myTrans");
        StepMeta step1 = new StepMeta("name1", null);
        StepMeta step2 = new StepMeta("name2", null);
        StepMeta step3 = new StepMeta("name3", null);
        StepMeta step4 = new StepMeta("name4", null);
        TransHopMeta hopMeta1 = new TransHopMeta(step1, step2, true);
        TransHopMeta hopMeta2 = new TransHopMeta(step2, step3, true);
        TransHopMeta hopMeta3 = new TransHopMeta(step3, step4, false);
        transMeta.addTransHop(0, hopMeta1);
        transMeta.addTransHop(1, hopMeta2);
        transMeta.addTransHop(2, hopMeta3);
        List hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step1, hops.get(0));
        Assert.assertSame((Object)step2, hops.get(1));
        Assert.assertSame((Object)step3, hops.get(2));
        Assert.assertSame((Object)step4, hops.get(3));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHop("name2 --> name3 (enabled)"));
        Assert.assertEquals((Object)hopMeta3, (Object)transMeta.findTransHopFrom(step3));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHop(hopMeta2));
        Assert.assertEquals((Object)hopMeta1, (Object)transMeta.findTransHop(step1, step2));
        Assert.assertEquals(null, (Object)transMeta.findTransHop(step3, step4, false));
        Assert.assertEquals((Object)hopMeta3, (Object)transMeta.findTransHop(step3, step4, true));
        Assert.assertEquals((Object)hopMeta2, (Object)transMeta.findTransHopTo(step3));
        transMeta.removeTransHop(0);
        hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step2, hops.get(0));
        Assert.assertSame((Object)step3, hops.get(1));
        Assert.assertSame((Object)step4, hops.get(2));
        transMeta.removeTransHop(hopMeta2);
        hops = transMeta.getTransHopSteps(true);
        Assert.assertSame((Object)step3, hops.get(0));
        Assert.assertSame((Object)step4, hops.get(1));
    }

    private static StepMeta mockStepMeta(String name) {
        StepMeta meta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)name);
        return meta;
    }
}

