/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;

public class TransPartitioningTest {
    private final String ONE = "1";
    private final String TWO = "2";
    private final String S10 = "1.0";
    private final String S11 = "1.1";
    private final String S20 = "2.0";
    private final String S21 = "2.1";
    private final String PID1 = "a";
    private final String PID2 = "b";
    private final String SP10 = "1.a";
    private final String SP11 = "1.b";
    private final String SP20 = "2.a";
    private final String SP21 = "2.b";
    @Mock
    LogChannelInterface log;
    Trans trans;
    private final NavigableSet<StepMeta> chain = new TreeSet<StepMeta>();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.trans = new Trans(){

            public void calculateBatchIdAndDateRange() throws KettleTransException {
            }

            public void beginProcessing() throws KettleTransException {
            }
        };
        TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)"junit meta");
        Mockito.when((Object)meta.getTransformationType()).thenReturn((Object)TransMeta.TransformationType.Normal);
        Mockito.when((Object)meta.getSizeRowset()).thenReturn((Object)13);
        Mockito.when((Object)meta.getTransHopSteps(Mockito.anyBoolean())).thenAnswer((Answer)new Answer<List<StepMeta>>(){

            public List<StepMeta> answer(InvocationOnMock invocation) throws Throwable {
                return new ArrayList<StepMeta>(TransPartitioningTest.this.chain);
            }
        });
        Mockito.when((Object)meta.findNextSteps((StepMeta)Mockito.any(StepMeta.class))).then((Answer)new Answer<List<StepMeta>>(){

            public List<StepMeta> answer(InvocationOnMock invocation) throws Throwable {
                Object obj = invocation.getArguments()[0];
                StepMeta findFor = (StepMeta)StepMeta.class.cast(obj);
                ArrayList<StepMeta> ret = new ArrayList<StepMeta>();
                StepMeta nextStep = TransPartitioningTest.this.chain.higher(findFor);
                if (nextStep != null) {
                    ret.add(nextStep);
                }
                return ret;
            }
        });
        Mockito.when((Object)meta.findPreviousSteps((StepMeta)Mockito.any(StepMeta.class), Mockito.anyBoolean())).thenAnswer((Answer)new Answer<List<StepMeta>>(){

            public List<StepMeta> answer(InvocationOnMock invocation) throws Throwable {
                Object obj = invocation.getArguments()[0];
                StepMeta findFor = (StepMeta)StepMeta.class.cast(obj);
                ArrayList<StepMeta> ret = new ArrayList<StepMeta>();
                StepMeta prevStep = TransPartitioningTest.this.chain.lower(findFor);
                if (prevStep != null) {
                    ret.add(prevStep);
                }
                return ret;
            }
        });
        Mockito.when((Object)meta.findStep(Mockito.anyString())).thenAnswer((Answer)new Answer<StepMeta>(){

            public StepMeta answer(InvocationOnMock invocation) throws Throwable {
                Object obj = invocation.getArguments()[0];
                String findFor = (String)String.class.cast(obj);
                for (StepMeta item : TransPartitioningTest.this.chain) {
                    if (!item.getName().equals(findFor)) continue;
                    return item;
                }
                return null;
            }
        });
        this.trans.setLog(this.log);
        this.trans.setTransMeta(meta);
    }

    @Test
    public void testOneToManyCopies() throws KettleException {
        this.prepareStepMetas_1_x2();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 2 rowsets finally", (long)2L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 3 steps: one producer and 2 copies of consumer", (long)3L, (long)this.trans.getSteps().size());
        StepInterface stepOne = this.getStepByName("1.0");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 2 output rowsets", (long)2L, (long)stepOne.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.0");
        Assert.assertEquals((String)"2.0 step have 12 input row sets", (long)1L, (long)stepTwo0.getInputRowSets().size());
        Assert.assertTrue((String)"2.0 step have no output row sets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        StepInterface stepTwo1 = this.getStepByName("2.1");
        Assert.assertEquals((String)"2.1 step have 1 input row sets", (long)1L, (long)stepTwo1.getInputRowSets().size());
        Assert.assertTrue((String)"2.1 step have no output row sets", (boolean)stepTwo1.getOutputRowSets().isEmpty());
    }

    @Test
    public void testManyToManyCopies() throws KettleException {
        this.prepareStepMetas_x2_x2();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 2 rowsets finally", (long)2L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 4 steps: 2 copies of producer and 2 copies of consumer", (long)4L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.0");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 1 output rowsets", (long)1L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepOne1 = this.getStepByName("1.1");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne1.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 1 output rowsets", (long)1L, (long)stepOne1.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.0");
        Assert.assertEquals((String)"2.0 step have 1 input row sets", (long)1L, (long)stepTwo0.getInputRowSets().size());
        Assert.assertTrue((String)"2.0 step have no output row sets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        StepInterface stepTwo1 = this.getStepByName("2.1");
        Assert.assertEquals((String)"2.1 step have 1 input row sets", (long)1L, (long)stepTwo1.getInputRowSets().size());
        Assert.assertTrue((String)"2.1 step have no output row sets", (boolean)stepTwo1.getOutputRowSets().isEmpty());
    }

    @Test
    public void testManyToOneCopies() throws KettleException {
        this.prepareStepMetas_x2_1();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 2 rowsets finally", (long)2L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 4 steps: 2 copies of producer and 2 copies of consumer", (long)3L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.0");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 1 output rowsets", (long)1L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepOne1 = this.getStepByName("1.1");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne1.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 1 output rowsets", (long)1L, (long)stepOne1.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.0");
        Assert.assertEquals((String)"2.0 step have 2 input row sets", (long)2L, (long)stepTwo0.getInputRowSets().size());
        Assert.assertTrue((String)"2.0 step have no output row sets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
    }

    @Test
    public void testOneToPartitioningSchema() throws KettleException {
        this.prepareStepMetas_1_cl1();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 2 rowsets finally", (long)2L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 3 steps: 1 producer and 2 copies of consumer since it is partitioned", (long)3L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.0");
        Assert.assertTrue((String)"1 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1 step have 2 output rowsets", (long)2L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.a");
        Assert.assertEquals((String)"2.0 step have one input row sets", (long)1L, (long)stepTwo0.getInputRowSets().size());
        Assert.assertTrue((String)"2.0 step have no output rowsets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        StepInterface stepTwo1 = this.getStepByName("2.b");
        Assert.assertEquals((String)"2.1 step have 1 input row sets", (long)1L, (long)stepTwo1.getInputRowSets().size());
        Assert.assertTrue((String)"2.1 step have no output row sets", (boolean)stepTwo1.getOutputRowSets().isEmpty());
    }

    @Test
    public void testSwimLanesPartitioning() throws KettleException {
        this.prepareStepMetas_cl1_cl1();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 2 rowsets finally", (long)2L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 3 steps: 1 producer and 2 copies of consumer since it is partitioned", (long)4L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.a");
        Assert.assertTrue((String)"1.0 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.0 step have 1 output rowsets", (long)1L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepOne1 = this.getStepByName("1.b");
        Assert.assertTrue((String)"1.1 step have no input row sets", (boolean)stepOne1.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.1 step have 1 output rowsets", (long)1L, (long)stepOne1.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.a");
        Assert.assertEquals((String)"2.0 step have 2 input row sets", (long)1L, (long)stepTwo0.getInputRowSets().size());
        Assert.assertTrue((String)"2.0 step have no output rowsets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        StepInterface stepTwo2 = this.getStepByName("2.b");
        Assert.assertTrue((String)"2.2 step have no output row sets", (boolean)stepTwo2.getOutputRowSets().isEmpty());
        Assert.assertEquals((String)"2.2 step have 2 output rowsets", (long)1L, (long)stepTwo2.getInputRowSets().size());
    }

    @Test
    public void testDifferentPartitioningFlow() throws KettleException {
        this.prepareStepMetas_cl1_cl2();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 4 rowsets finally since repartitioning happens", (long)4L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 4 steps: 2 producer copies and 2 copies of consumer since they both partitioned", (long)4L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.a");
        Assert.assertTrue((String)"1.0 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.0 step have 2 output rowsets", (long)2L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepOne1 = this.getStepByName("1.b");
        Assert.assertTrue((String)"1.1 step have no input row sets", (boolean)stepOne1.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.1 step have 2 output rowsets", (long)2L, (long)stepOne1.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.a");
        Assert.assertTrue((String)"2.0 step have no output row sets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        Assert.assertEquals((String)"2.0 step have 1 input rowsets", (long)2L, (long)stepTwo0.getInputRowSets().size());
        StepInterface stepTwo2 = this.getStepByName("2.b");
        Assert.assertTrue((String)"2.1 step have no output row sets", (boolean)stepTwo2.getOutputRowSets().isEmpty());
        Assert.assertEquals((String)"2.2 step have 2 input rowsets", (long)2L, (long)stepTwo2.getInputRowSets().size());
    }

    @Test
    public void testManyCopiesToPartitioningFlow() throws KettleException {
        this.prepareStepMetas_x2_cl1();
        this.trans.prepareExecution(new String[0]);
        List rowsets = this.trans.getRowsets();
        Assert.assertTrue((!rowsets.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"We have 4 rowsets finally since repartitioning happens", (long)4L, (long)rowsets.size());
        Assert.assertEquals((String)"We have 4 steps: 2 producer copies and 2 copies of consumer since consumer is partitioned", (long)4L, (long)this.trans.getSteps().size());
        StepInterface stepOne0 = this.getStepByName("1.0");
        Assert.assertTrue((String)"1.0 step have no input row sets", (boolean)stepOne0.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.0 step have 2 output rowsets", (long)2L, (long)stepOne0.getOutputRowSets().size());
        StepInterface stepOne1 = this.getStepByName("1.1");
        Assert.assertTrue((String)"1.1 step have no input row sets", (boolean)stepOne1.getInputRowSets().isEmpty());
        Assert.assertEquals((String)"1.1 step have 2 output rowsets", (long)2L, (long)stepOne1.getOutputRowSets().size());
        StepInterface stepTwo0 = this.getStepByName("2.a");
        Assert.assertTrue((String)"2.0 step have no output row sets", (boolean)stepTwo0.getOutputRowSets().isEmpty());
        Assert.assertEquals((String)"2.0 step have 2 input rowsets", (long)2L, (long)stepTwo0.getInputRowSets().size());
        StepInterface stepTwo2 = this.getStepByName("2.b");
        Assert.assertTrue((String)"2.1 step have no output row sets", (boolean)stepTwo2.getOutputRowSets().isEmpty());
        Assert.assertEquals((String)"2.2 step have 2 input rowsets", (long)2L, (long)stepTwo2.getInputRowSets().size());
    }

    private StepInterface getStepByName(String name) {
        List combiList = this.trans.getSteps();
        for (StepMetaDataCombi item : combiList) {
            if (!item.step.toString().equals(name)) continue;
            return item.step;
        }
        Assert.fail((String)("Test error, can't find step with name: " + name));
        return null;
    }

    private void prepareStepMetas_1_x2() {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        dummy2.setCopies(2);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_x2_x2() {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        dummy1.setCopies(2);
        dummy2.setCopies(2);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_x2_1() {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        dummy1.setCopies(2);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_1_cl1() throws KettlePluginException {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        PartitionSchema schema = new PartitionSchema("p1", Arrays.asList("a", "b"));
        StepPartitioningMeta partMeta = new StepPartitioningMeta("Mirror to all partitions", schema);
        dummy2.setStepPartitioningMeta(partMeta);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_cl1_cl1() throws KettlePluginException {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        PartitionSchema schema = new PartitionSchema("p1", Arrays.asList("a", "b"));
        StepPartitioningMeta partMeta = new StepPartitioningMeta("Mirror to all partitions", schema);
        partMeta.setPartitionSchemaName(schema.getName());
        dummy1.setStepPartitioningMeta(partMeta);
        dummy2.setStepPartitioningMeta(partMeta);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_cl1_cl2() throws KettlePluginException {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        PartitionSchema schema1 = new PartitionSchema("p1", Arrays.asList("a", "b"));
        PartitionSchema schema2 = new PartitionSchema("p2", Arrays.asList("a", "b"));
        StepPartitioningMeta partMeta1 = new StepPartitioningMeta("Mirror to all partitions", schema1);
        StepPartitioningMeta partMeta2 = new StepPartitioningMeta("Mirror to all partitions", schema2);
        partMeta1.setPartitionSchemaName(schema1.getName());
        partMeta2.setPartitionSchemaName(schema2.getName());
        dummy1.setStepPartitioningMeta(partMeta1);
        dummy2.setStepPartitioningMeta(partMeta2);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }

    private void prepareStepMetas_x2_cl1() throws KettlePluginException {
        StepMeta dummy1 = new StepMeta("1", null);
        StepMeta dummy2 = new StepMeta("2", null);
        PartitionSchema schema1 = new PartitionSchema("p1", Arrays.asList("a", "b"));
        StepPartitioningMeta partMeta1 = new StepPartitioningMeta("Mirror to all partitions", schema1);
        dummy2.setStepPartitioningMeta(partMeta1);
        dummy1.setCopies(2);
        this.chain.add(dummy1);
        this.chain.add(dummy2);
        for (StepMeta item : this.chain) {
            item.setStepMetaInterface((StepMetaInterface)new DummyTransMeta());
        }
    }
}

