/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransStoppedListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;

public class TransTest {
    int count = 10000;
    Trans trans;
    TransMeta meta;
    private final TransListener listener = new TransListener(){

        public void transStarted(Trans trans) throws KettleException {
        }

        public void transActive(Trans trans) {
        }

        public void transFinished(Trans trans) throws KettleException {
        }
    };
    private final TransStoppedListener transStoppedListener = new TransStoppedListener(){

        public void transStopped(Trans trans) {
        }
    };

    @BeforeClass
    public static void beforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void beforeTest() throws KettleException {
        this.meta = new TransMeta();
        this.trans = new Trans(this.meta);
        this.trans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        this.trans.prepareExecution(null);
        this.trans.startThreads();
    }

    @Test
    public void testFindDatabaseWithEncodedConnectionName() {
        DatabaseMeta dbMeta1 = new DatabaseMeta("encoded_DBConnection", "Oracle", "localhost", "access", "test", "111", "test", "test");
        dbMeta1.setDisplayName("encoded.DBConnection");
        this.meta.addDatabase(dbMeta1);
        DatabaseMeta dbMeta2 = new DatabaseMeta("normalDBConnection", "Oracle", "localhost", "access", "test", "111", "test", "test");
        dbMeta2.setDisplayName("normalDBConnection");
        this.meta.addDatabase(dbMeta2);
        DatabaseMeta databaseMeta = this.meta.findDatabase(dbMeta1.getDisplayName());
        Assert.assertNotNull((Object)databaseMeta);
        Assert.assertEquals((Object)databaseMeta.getName(), (Object)"encoded_DBConnection");
        Assert.assertEquals((Object)databaseMeta.getDisplayName(), (Object)"encoded.DBConnection");
    }

    @Test
    public void testLoggingObjectIsNotLeakInMeta() {
        String expected = this.meta.log.getLogChannelId();
        this.meta.clear();
        String actual = this.meta.log.getLogChannelId();
        Assert.assertEquals((String)"Use same logChannel for empty constructors, or assign General level for clear() calls", (Object)expected, (Object)actual);
    }

    @Test
    public void testLoggingObjectIsNotLeakInTrans() throws KettleException {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectoryInterface repInt = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)rep.loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(RepositoryDirectoryInterface.class), (ProgressMonitorListener)Mockito.any(ProgressMonitorListener.class), Mockito.anyBoolean(), Mockito.anyString())).thenReturn((Object)this.meta);
        Mockito.when((Object)rep.findDirectory(Mockito.anyString())).thenReturn((Object)repInt);
        Trans trans = new Trans((VariableSpace)this.meta, rep, "junit", "junitDir", "fileName");
        Assert.assertEquals((String)"Log channel General assigned", (Object)LogChannel.GENERAL.getLogChannelId(), (Object)trans.log.getLogChannelId());
    }

    @Test
    public void testTransFinishListenersConcurrentModification() throws KettleException, InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransFinishListenerAdder add = new TransFinishListenerAdder(this.trans, start);
        TransFinishListenerFirer firer = new TransFinishListenerFirer(this.trans, start);
        this.startThreads(add, firer, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Finish listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)firer.c);
    }

    @Test
    public void testTransStartListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransFinishListenerAdder add = new TransFinishListenerAdder(this.trans, start);
        TransStartListenerFirer starter = new TransStartListenerFirer(this.trans, start);
        this.startThreads(add, starter, start);
        Assert.assertEquals((String)"All listeners are added: no ConcurrentModificationException", (long)this.count, (long)add.c);
        Assert.assertEquals((String)"All Start listeners are iterated over: no ConcurrentModificationException", (long)this.count, (long)starter.c);
    }

    @Test
    public void testTransStoppedListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        TransStoppedCaller stopper = new TransStoppedCaller(this.trans, start);
        TransStopListenerAdder adder = new TransStopListenerAdder(this.trans, start);
        this.startThreads(stopper, adder, start);
        Assert.assertEquals((String)"All transformation stop listeners is added", (long)this.count, (long)adder.c);
        Assert.assertEquals((String)"All stop call success", (long)this.count, (long)stopper.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPDI12424ParametersFromMetaAreCopiedToTrans() throws KettleException, URISyntaxException, IOException {
        String testParam = "testParam";
        String testParamValue = "testParamValue";
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)mockTransMeta.listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)mockTransMeta.listParameters()).thenReturn((Object)new String[]{testParam});
        Mockito.when((Object)mockTransMeta.getParameterValue(testParam)).thenReturn((Object)testParamValue);
        FileObject ktr = KettleVFS.createTempFile((String)"parameters", (String)".ktr", (String)"ram://");
        try (OutputStream outputStream = ktr.getContent().getOutputStream(true);){
            ByteArrayInputStream inputStream = new ByteArrayInputStream("<transformation></transformation>".getBytes());
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        Trans trans = new Trans((VariableSpace)mockTransMeta, null, null, null, ktr.getURL().toURI().toString());
        Assert.assertEquals((Object)testParamValue, (Object)trans.getParameterValue(testParam));
    }

    @Test
    public void testTransListeners() {
        TransMeta TransMeta2 = new TransMeta();
        StepMeta oldFormStep = new StepMeta();
        oldFormStep.setName("Generate_1");
        StepMeta newFormStep = new StepMeta();
        newFormStep.setName("Generate_2");
        StepMeta toStep = new StepMeta();
        toStep.setStepMetaInterface((StepMetaInterface)new MetaInjectMeta());
        toStep.setName("ETL Inject Metadata");
        StepMeta deletedStep = new StepMeta();
        deletedStep.setStepMetaInterface((StepMetaInterface)new MetaInjectMeta());
        deletedStep.setName("ETL Inject Metadata for delete");
        TransMeta2.addStep(oldFormStep);
        TransMeta2.addStep(toStep);
        TransMeta2.addStep(deletedStep);
        Assert.assertEquals((long)TransMeta2.nrStepChangeListeners(), (long)2L);
        TransMeta2.removeStepChangeListener((StepMetaChangeListenerInterface)deletedStep.getStepMetaInterface());
        Assert.assertEquals((long)TransMeta2.nrStepChangeListeners(), (long)1L);
        TransMeta2.removeStep(2);
        TransHopMeta hi = new TransHopMeta(oldFormStep, toStep);
        TransMeta2.addTransHop(hi);
        MetaInjectMeta toMeta = (MetaInjectMeta)toStep.getStepMetaInterface();
        Map sourceMapping = new HashMap<TargetStepAttribute, SourceStepField>();
        TargetStepAttribute keyTest = new TargetStepAttribute("File", "key", true);
        SourceStepField valueTest = new SourceStepField(oldFormStep.getName(), oldFormStep.getName());
        sourceMapping.put(keyTest, valueTest);
        toMeta.setTargetSourceMapping(sourceMapping);
        TransMeta2.notifyAllListeners(oldFormStep, newFormStep);
        sourceMapping = toMeta.getTargetSourceMapping();
        for (Map.Entry entry : sourceMapping.entrySet()) {
            SourceStepField value = (SourceStepField)entry.getValue();
            if (value.getStepname().equals(newFormStep.getName())) continue;
            Assert.fail();
        }
        TransMeta2.addStep(1, deletedStep);
        Assert.assertEquals((long)TransMeta2.nrSteps(), (long)3L);
        Assert.assertEquals((long)TransMeta2.nrStepChangeListeners(), (long)2L);
        TransMeta2.removeStep(0);
        Assert.assertEquals((long)TransMeta2.nrSteps(), (long)2L);
    }

    @Test
    public void testRecordsCleanUpMethodIsCalled() throws Exception {
        Database mockedDataBase = (Database)Mockito.mock(Database.class);
        Trans trans = (Trans)Mockito.mock(Trans.class);
        StepLogTable stepLogTable = StepLogTable.getDefault((VariableSpace)((VariableSpace)Mockito.mock(VariableSpace.class)), (HasDatabasesInterface)((HasDatabasesInterface)Mockito.mock(HasDatabasesInterface.class)));
        stepLogTable.setConnectionName("connection");
        TransMeta transMeta = new TransMeta();
        transMeta.setStepLogTable(stepLogTable);
        Mockito.when((Object)trans.getTransMeta()).thenReturn((Object)transMeta);
        Mockito.when((Object)trans.createDataBase((DatabaseMeta)Matchers.any(DatabaseMeta.class))).thenReturn((Object)mockedDataBase);
        Mockito.when((Object)trans.getSteps()).thenReturn(new ArrayList());
        ((Trans)Mockito.doCallRealMethod().when((Object)trans)).writeStepLogInformation();
        trans.writeStepLogInformation();
        ((Database)Mockito.verify((Object)mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)stepLogTable);
    }

    private void startThreads(Runnable one, Runnable two, CountDownLatch start) throws InterruptedException {
        Thread th = new Thread(one);
        Thread tt = new Thread(two);
        th.start();
        tt.start();
        start.countDown();
        th.join();
        tt.join();
    }

    private class TransStartListenerFirer
    extends TransKicker {
        TransStartListenerFirer(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.tr.fireTransStartedListeners();
                }
                catch (KettleException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class TransFinishListenerFirer
    extends TransKicker {
        TransFinishListenerFirer(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                try {
                    this.tr.fireTransFinishedListeners();
                    this.tr.waitUntilFinished();
                }
                catch (KettleException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class TransFinishListenerAdder
    extends TransKicker {
        TransFinishListenerAdder(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                this.tr.addTransListener(TransTest.this.listener);
            }
        }
    }

    private class TransStopListenerAdder
    extends TransKicker {
        TransStopListenerAdder(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                TransTest.this.trans.addTransStoppedListener(TransTest.this.transStoppedListener);
            }
        }
    }

    private class TransStoppedCaller
    extends TransKicker {
        TransStoppedCaller(Trans tr, CountDownLatch start) {
            super(tr, start);
        }

        @Override
        public void run() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            while (!this.isStopped()) {
                TransTest.this.trans.stopAll();
            }
        }
    }

    private abstract class TransKicker
    implements Runnable {
        protected Trans tr;
        protected int c = 0;
        protected CountDownLatch start;
        protected int max;

        TransKicker(Trans tr, CountDownLatch start) {
            this.max = TransTest.this.count;
            this.tr = tr;
            this.start = start;
        }

        protected boolean isStopped() {
            ++this.c;
            return this.c >= this.max;
        }
    }
}

