/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.steps.autodoc.AutoDocOptionsInterface;
import org.pentaho.di.trans.steps.autodoc.KettleReportBuilder;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;

public class KettleReportBuilderTest {
    @Before
    public void initReportEnv() {
        if (!ClassicEngineBoot.getInstance().isBootDone()) {
            ObjectUtilities.setClassLoader((ClassLoader)this.getClass().getClassLoader());
            ObjectUtilities.setClassLoaderSource((String)"ClassContext");
            LibLoaderBoot.getInstance().start();
            LibFontBoot.getInstance().start();
            ClassicEngineBoot.getInstance().start();
        }
    }

    @Test
    public void createReport() throws Exception {
        LoggingObjectInterface log = (LoggingObjectInterface)Mockito.mock(LoggingObjectInterface.class);
        AutoDocOptionsInterface options = (AutoDocOptionsInterface)Mockito.mock(AutoDocOptionsInterface.class);
        Mockito.when((Object)options.isIncludingImage()).thenReturn((Object)Boolean.TRUE);
        KettleReportBuilder builder = new KettleReportBuilder(log, Collections.emptyList(), "", options);
        builder.createReport();
        Assert.assertNotNull((Object)builder.getReport());
        Assert.assertNotNull((Object)builder.getReport().getDataFactory());
        Assert.assertNotNull((Object)builder.getReport().getReportHeader());
        Assert.assertNotNull((Object)builder.getReport().getReportFooter());
        Assert.assertNotNull((Object)builder.getReport().getRootGroup());
        Assert.assertNotNull((Object)builder.getReport().getPageDefinition());
        Assert.assertTrue((builder.getReport().getExpressions().size() > 0 ? 1 : 0) != 0);
    }
}

