/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.clonerow;

import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.clonerow.CloneRow;
import org.pentaho.di.trans.steps.clonerow.CloneRowData;
import org.pentaho.di.trans.steps.clonerow.CloneRowMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class CloneRowTest {
    private StepMockHelper<CloneRowMeta, CloneRowData> stepMockHelper;

    @Before
    public void setup() {
        this.stepMockHelper = new StepMockHelper<CloneRowMeta, CloneRowData>("Test CloneRow", CloneRowMeta.class, CloneRowData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.stepMockHelper.cleanUp();
    }

    @Test(expected=KettleException.class)
    public void nullNrCloneField() throws Exception {
        CloneRow step = new CloneRow(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        step.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.getInteger((Object[])Matchers.any(Object[].class), Matchers.anyInt())).thenReturn(null);
        RowSet inputRowSet = this.stepMockHelper.getMockInputRowSet(new Object[][]{{null}});
        Mockito.when((Object)inputRowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        step.setInputRowSets(Collections.singletonList(inputRowSet));
        Mockito.when((Object)((CloneRowMeta)this.stepMockHelper.processRowsStepMetaInterface).isNrCloneInField()).thenReturn((Object)true);
        Mockito.when((Object)((CloneRowMeta)this.stepMockHelper.processRowsStepMetaInterface).getNrCloneField()).thenReturn((Object)"field");
        step.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface);
    }
}

